import { Vector3, Intersection } from 'three';
import { IfcComponent } from '../../../base-types';
import { IfcPlane } from './planes';
import { IfcManager } from '../../ifc';
import { IfcContext } from '../../context';
export declare class IfcClipper extends IfcComponent {
    dragging: boolean;
    planes: IfcPlane[];
    intersection: Intersection | undefined;
    orthogonalY: boolean;
    toleranceOrthogonalY: number;
    planeSize: number;
    private edgesEnabled;
    private enabled;
    private readonly context;
    private readonly ifc;
    constructor(context: IfcContext, ifc: IfcManager);
    get active(): boolean;
    set active(state: boolean);
    get edgesActive(): boolean;
    set edgesActive(state: boolean);
    toggle(): void;
    dispose(): void;
    createPlane: () => void;
    createFromNormalAndCoplanarPoint: (normal: Vector3, point: Vector3, isPlan?: boolean) => IfcPlane;
    deletePlane: (plane?: IfcPlane | undefined) => void;
    deleteAllPlanes: () => void;
    private pickPlane;
    private createPlaneFromIntersection;
    private normalizePlaneDirectionY;
    private newPlane;
    private activateDragging;
    private deactivateDragging;
    private updateMaterials;
    private updateMaterial;
}
