import { BufferGeometry, Color, LineBasicMaterial, Mesh, MeshBasicMaterial, Vector3 } from 'three';
import { CSS2DObject } from 'three/examples/jsm/renderers/CSS2DRenderer';
import { IfcContext } from '../../context';
export declare class IfcDimensionLine {
    private readonly context;
    private readonly labelClassName;
    static scaleFactor: number;
    static scale: number;
    static units: string;
    private root;
    private readonly line;
    private readonly textLabel;
    private endpointMeshes;
    private readonly axis;
    private endpoint;
    start: Vector3;
    end: Vector3;
    center: Vector3;
    private length;
    private scale;
    private readonly lineMaterial;
    private readonly endpointMaterial;
    private boundingMesh?;
    private readonly boundingSize;
    constructor(context: IfcContext, start: Vector3, end: Vector3, lineMaterial: LineBasicMaterial, endpointMaterial: MeshBasicMaterial, endpointGeometry: BufferGeometry, className: string, endpointScale: Vector3);
    dispose(): void;
    get boundingBox(): Mesh<BufferGeometry, import("three").Material | import("three").Material[]> | undefined;
    get text(): CSS2DObject;
    set dimensionColor(dimensionColor: Color);
    set visibility(visible: boolean);
    set endpointGeometry(geometry: BufferGeometry);
    set endpointScale(scale: Vector3);
    set endPoint(point: Vector3);
    removeFromScene(): void;
    createBoundingBox(): void;
    private rescaleObjectsToCameraPosition;
    private rescaleMesh;
    private addEndpointMeshes;
    private newEndpointMesh;
    private newText;
    private getTextContent;
    private newBoundingBox;
    private setupBoundingBox;
    private getLength;
    private getCenter;
}
