import { BufferGeometry, Color, Object3D, Vector3 } from 'three';
import { CSS2DObject } from 'three/examples/jsm/renderers/CSS2DRenderer';
import { IfcComponent } from '../../../base-types';
import { IfcDimensionLine } from './dimension-line';
import { IfcContext } from '../../context';
export declare class IfcDimensions extends IfcComponent {
    private readonly context;
    private dimensions;
    private currentDimension?;
    readonly labelClassName = "ifcjs-dimension-label";
    readonly previewClassName = "ifcjs-dimension-preview";
    private enabled;
    private preview;
    private dragging;
    snapDistance: number;
    private baseScale;
    private endpoint;
    private previewElement;
    private lineMaterial;
    private endpointsMaterial;
    private startPoint;
    private endPoint;
    constructor(context: IfcContext);
    dispose(): void;
    update(_delta: number): void;
    setArrow(height: number, radius: number): void;
    setPreviewElement(element: HTMLElement): void;
    get active(): boolean;
    get previewActive(): boolean;
    get previewObject(): CSS2DObject;
    set previewActive(state: boolean);
    set active(state: boolean);
    set dimensionsColor(color: Color);
    set dimensionsWidth(width: number);
    set endpointGeometry(geometry: BufferGeometry);
    set endpointScaleFactor(factor: number);
    set endpointScale(scale: Vector3);
    create(): void;
    createInPlane(plane: Object3D): void;
    delete(): void;
    deleteAll(): void;
    cancelDrawing(): void;
    setDimensionUnit(units: string): void;
    private drawStart;
    private drawStartInPlane;
    private drawInProcess;
    private drawEnd;
    get getDimensionsLines(): IfcDimensionLine[];
    private drawDimension;
    private getBoundingBoxes;
    private static getDefaultEndpointGeometry;
    private getClosestVertex;
    private getVertices;
    private getVertex;
}
