import { Material } from 'three';
import { IfcSelection } from './selection';
import { IfcManager } from '../ifc-manager';
import { IfcContext } from '../../context';
export declare class IfcSelector {
    private context;
    private ifc;
    preselection: IfcSelection;
    selection: IfcSelection;
    highlight: IfcSelection;
    defHighlightMat: Material;
    private readonly defPreselectMat;
    private readonly defSelectMat;
    private readonly userDataField;
    constructor(context: IfcContext, ifc: IfcManager);
    dispose(): void;
    /**
     * Highlights the item pointed by the cursor.
     */
    prePickIfcItem(): Promise<void>;
    /**
     * Highlights the item pointed by the cursor and gets is properties.
     * @focusSelection If true, animate the perspectiveCamera to focus the current selection
     * @removePrevious whether to remove the previous subset
     */
    pickIfcItem(focusSelection?: boolean, removePrevious?: boolean): Promise<{
        modelID: number;
        id: number;
    } | null>;
    /**
     * Highlights the item pointed by the cursor and gets is properties, without applying any material to it.
     * @focusSelection If true, animate the perspectiveCamera to focus the current selection
     * @removePrevious whether to remove the previous subset
     */
    highlightIfcItem(focusSelection?: boolean, removePrevious?: boolean): Promise<{
        modelID: number;
        id: number;
    } | null>;
    /**
     * Highlights the item with the given ID with the picking material.
     * @modelID ID of the IFC model.
     * @id Express ID of the item.
     * @focusSelection If true, animate the perspectiveCamera to focus the current selection
     * @removePrevious whether to remove the previous subset
     */
    pickIfcItemsByID(modelID: number, ids: number[], focusSelection?: boolean, removePrevious?: boolean): Promise<void>;
    /**
     * Highlights the item with the given ID with the prepicking material.
     * @modelID ID of the IFC model.
     * @id Express ID of the item.
     * @focusSelection If true, animate the perspectiveCamera to focus the current selection
     * @removePrevious whether to remove the previous subset
     */
    prepickIfcItemsByID(modelID: number, ids: number[], focusSelection?: boolean, removePrevious?: boolean): Promise<void>;
    /**
     * Highlights the item with the given ID and fades away the model.
     * @modelID ID of the IFC model.
     * @id Express ID of the item.
     * @focusSelection If true, animate the perspectiveCamera to focus the current selection
     * @removePrevious whether to remove the previous subset
     */
    highlightIfcItemsByID(modelID: number, ids: number[], focusSelection?: boolean, removePrevious?: boolean): Promise<void>;
    /**
     * Unapplies the picking material.
     */
    unpickIfcItems(): void;
    /**
     * Unapplies the prepicking material.
     */
    unPrepickIfcItems(): void;
    /**
     * Unapplies the highlight material, removing the fading of the model
     */
    unHighlightIfcItems(): void;
    private unHighlightItem;
    private fadeAwayModels;
    private initializeDefMaterial;
}
