import { IFCUNITASSIGNMENT } from 'web-ifc';
export var UnitType;
(function (UnitType) {
    UnitType["LENGTHUNIT"] = "LENGTHUNIT";
    UnitType["AREAUNIT"] = "AREAUNIT";
    UnitType["VOLUMEUNIT"] = "VOLUMEUNIT";
})(UnitType || (UnitType = {}));
export const UnitScale = {
    MILLI: 0.001,
    CENTI: 0.01,
    DECI: 0.1,
    NONE: 1,
    DECA: 10,
    HECTO: 100,
    KILO: 1000
};
export class IfcUnits {
    constructor(ifc) {
        this.allUnits = {};
        this.ifc = ifc;
    }
    dispose() {
        this.allUnits = null;
        this.ifc = null;
    }
    async getUnits(modelID, type) {
        if (!this.allUnits[modelID]) {
            await this.getUnitsOfModel(modelID);
        }
        return this.allUnits[modelID][type];
    }
    async getUnitsOfModel(modelID) {
        this.allUnits[modelID] = {};
        const foundUnitsID = await this.ifc.getAllItemsOfType(modelID, IFCUNITASSIGNMENT, false);
        const unitsID = foundUnitsID[0];
        const unitReference = await this.ifc.getProperties(modelID, unitsID, false, true);
        const units = unitReference.Units;
        Object.values(UnitType).forEach((value) => {
            const foundUnit = units.find((item) => item.UnitType && item.UnitType.value === value);
            if (foundUnit) {
                const prefix = foundUnit.Prefix;
                let scale;
                if (prefix === null || prefix === undefined)
                    scale = UnitScale.NONE;
                else
                    scale = UnitScale[prefix.value];
                this.allUnits[modelID][value] = scale;
            }
        });
    }
}
//# sourceMappingURL=units.js.map