import { Group, Matrix4, Mesh } from 'three';
import { IFCModel } from 'web-ifc-three/IFC/components/IFCModel';
import { IfcComponent } from '../../base-types';
import { IfcContext } from '../context';
import { IfcManager } from '../ifc';
export interface ExportConfig {
    ifcFileUrl: string;
    getProperties?: boolean;
    categories?: {
        [categoryName: string]: number[];
    };
    splitByFloors?: boolean;
    maxJSONSize?: number;
    onProgress?: (progress: number, total: number, process: string) => void;
    coordinationMatrix?: Matrix4;
}
export interface ExportResponse {
    gltf: {
        [categoryName: string]: {
            [floorName: string]: {
                height: number;
                file: File | null;
            };
        };
    };
    json: File[];
    coordinationMatrix: number[];
    id: string;
}
export interface IdsByFloorplan {
    [p: string]: {
        height: number;
        ids: Set<number>;
    };
}
export declare class GLTFManager extends IfcComponent {
    private context;
    private IFC;
    GLTFModels: {
        [modelID: number]: Group;
    };
    private loader;
    private exporter;
    private tempIfcLoader;
    private allFloors;
    private allCategories;
    private stories;
    options: {
        trs: boolean;
        onlyVisible: boolean;
        truncateDrawRange: boolean;
        binary: boolean;
        maxTextureSize: number;
    };
    constructor(context: IfcContext, IFC: IfcManager);
    dispose(): void;
    /**
     * Loads any glTF file into the scene using [Three.js loader](https://threejs.org/docs/#examples/en/loaders/GLTFLoader).
     * @url The URL of the GLTF file to load
     * @onProgress (optional) A callback function that is called when the file is loaded
     */
    load(url: string, onProgress?: (event: ProgressEvent<EventTarget>) => void): Promise<Group>;
    /**
     * Load glTF and enable IFC.js tools over it.
     * This just works if the glTF was previously exported from an IFC model using `exportIfcAsGltf()`.
     * @url The URL of the GLTF file to load
     */
    loadModel(url: string): Promise<IFCModel>;
    /**
     * Exports the specified IFC file (or file subset) as glTF.
     * @fileURL The URL of the IFC file to convert to glTF
     * @ids (optional) The ids of the items to export. If not defined, the full model is exported
     */
    exportIfcFileAsGltf(config: ExportConfig): Promise<ExportResponse>;
    private getProperties;
    private getModels;
    private setupIfcLoader;
    private overrideCoordMatrix;
    private getModelsByCategory;
    private getModelsWithoutCategories;
    /**
     * Exports the specified model (or model subset) as glTF.
     * @modelID The ID of the IFC model to convert to glTF
     * @ids (optional) The ids of the items to export. If not defined, the full model is exported
     */
    exportIfcAsGltf(modelID: number, ids?: number[]): Promise<any>;
    /**
     * Exports the given mesh as glTF.
     * @mesh The mesh to export.
     */
    exportMeshToGltf(mesh: Mesh): Promise<any>;
    private exportModelPartToGltf;
    private glTFToFile;
    private getIDsByFloor;
    private getStoreyName;
    private getChildrenRecursively;
    private getModelID;
    private getGltfMesh;
    private setupMeshAsModel;
    private cleanUpLoadedInformation;
    private getMaterials;
    private getMeshes;
    private getGeometry;
    private setupGeometryAttributes;
    private setupGeometryAttributesDraco;
    private fillArray;
    private setupGeometryIndex;
    private setupGeometryIndexDraco;
    private flattenIndices;
    private setupGroups;
}
