import { Color } from 'three';
import { IfcContext, IfcManager, ViewerOptions, IfcGrid, IfcAxes, IfcClipper, DropboxAPI, Edges, SectionFillManager, IfcDimensions, PlanManager } from './components';
import { GLTFManager } from './components/import-export/glTF';
import { ShadowDropper } from './components/display/shadow-dropper';
import { DXFWriter } from './components/import-export/dxf';
import { PDFWriter } from './components/import-export/pdf';
import { EdgeProjector } from './components/import-export/edges-vectorizer/edge-projection';
import { SelectionWindow } from './components/selection/selection-window';
export declare class IfcViewerAPI {
    context: IfcContext;
    IFC: IfcManager;
    GLTF: GLTFManager;
    clipper: IfcClipper;
    plans: PlanManager;
    filler: SectionFillManager;
    dimensions: IfcDimensions;
    edges: Edges;
    shadowDropper: ShadowDropper;
    dxf: DXFWriter;
    pdf: PDFWriter;
    edgesProjector: EdgeProjector;
    grid: IfcGrid;
    axes: IfcAxes;
    dropbox: DropboxAPI;
    selectionWindow: SelectionWindow;
    constructor(options: ViewerOptions);
    /**
     * @deprecated Use `IfcViewerAPI.clipper.createPlane()` instead.
     * Adds a clipping plane on the face pointed to by the cursor.
     */
    addClippingPlane: () => void;
    /**
     * @deprecated Use `IfcViewerAPI.clipper.deletePlane()` instead.
     * Removes the clipping plane pointed by the cursor.
     */
    removeClippingPlane: () => void;
    /**
     * @deprecated Use `IfcViewerAPI.clipper.toggle()` instead.
     * Turns on / off all clipping planes.
     */
    toggleClippingPlanes: () => void;
    /**
     * @deprecated Use `this.dropbox.loadDropboxIfc()` instead.
     * Opens a dropbox window where the user can select their IFC models.
     */
    openDropboxWindow(): void;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.loadIfc()` instead.
     * Loads the given IFC in the current scene.
     * @file IFC as File.
     * @fitToFrame (optional) if true, brings the perspectiveCamera to the loaded IFC.
     */
    loadIfc(file: File, fitToFrame?: boolean): Promise<void>;
    /**
     * @deprecated Use `IfcViewerAPI.grid.setGrid()` instead.
     * Adds a base [grid](https://threejs.org/docs/#api/en/helpers/GridHelper) to the scene.
     * @size (optional) Size of the grid.
     * @divisions (optional) Number of divisions in X and Y.
     * @ColorCenterLine (optional) Color of the XY central lines of the grid.
     * @colorGrid (optional) Color of the XY lines of the grid.
     */
    addGrid(size?: number, divisions?: number, colorCenterLine?: Color, colorGrid?: Color): void;
    /**
     * @deprecated Use `IfcViewerAPI.axes.setAxes()` instead.
     * Adds base [axes](https://threejs.org/docs/#api/en/helpers/AxesHelper) to the scene.
     * @size (optional) Size of the axes.
     */
    addAxes(size?: number): void;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.loadIfcUrl()` instead.
     * Loads the given IFC in the current scene.
     * @file IFC as URL.
     * @fitToFrame (optional) if true, brings the perspectiveCamera to the loaded IFC.
     */
    loadIfcUrl(url: string, fitToFrame?: boolean): Promise<void>;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.setWasmPath()` instead.
     * Sets the relative path of web-ifc.wasm file in the project.
     * Beware: you **must** serve this file in your page; this means
     * that you have to copy this files from *node_modules/web-ifc*
     * to your deployment directory.
     *
     * If you don't use this methods,
     * IFC.js assumes that you are serving it in the root directory.
     *
     * Example if web-ifc.wasm is in dist/wasmDir:
     * `ifcLoader.setWasmPath("dist/wasmDir/");`
     *
     * @path Relative path to web-ifc.wasm.
     */
    setWasmPath(path: string): void;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.getSpatialStructure()` instead.
     * Gets the spatial structure of the specified model.
     * @modelID ID of the IFC model.
     */
    getSpatialStructure(modelID: number): Promise<any>;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.getProperties()` instead.
     * Gets the properties of the specified item.
     * @modelID ID of the IFC model.
     * @id Express ID of the item.
     * @indirect If true, also returns psets, qsets and type properties.
     */
    getProperties(modelID: number, id: number, indirect: boolean): Promise<any>;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.getModelID()` instead.
     * Gets the ID of the model pointed by the cursor.
     */
    getModelID(): number | null;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.getAllItemsOfType()` instead.
     * Gets all the items of the specified type in the specified IFC model.
     * @modelID ID of the IFC model.
     * @type type of element. You can import the type from web-ifc.
     * @verbose If true, also gets the properties for all the elements.
     */
    getAllItemsOfType(modelID: number, type: number, verbose?: boolean): Promise<any[]>;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.selector.prePickIfcItem()` instead.
     * Highlights the item pointed by the cursor.
     */
    prePickIfcItem: () => void;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.selector.pickIfcItem()` instead.
     * Highlights the item pointed by the cursor and gets is properties.
     */
    pickIfcItem: () => Promise<{
        modelID: number;
        id: number;
    } | null>;
    /**
     * @deprecated Use `IfcViewerAPI.IFC.selector.pickIfcItemsByID()` instead.
     * Highlights the item with the given ID.
     * @modelID ID of the IFC model.
     * @id Express ID of the item.
     */
    pickIfcItemsByID: (modelID: number, ids: number[]) => void;
    /**
     * Releases all the memory allocated by IFC.js.
     * Use this only when deleting the ifcViewerAPI instance.
     * This is especially important when using libraries and frameworks that handle the lifecycle
     * of objects automatically (e.g. React, Angular, etc). If you are using one of these and are
     * instantiating webIfcViewer inside a component, make sure you use this method in the component
     * destruction event.
     */
    dispose(): Promise<void>;
}
