/**
 * @license
 * Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt The complete set of authors may be found
 * at http://polymer.github.io/AUTHORS.txt The complete set of contributors may
 * be found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by
 * Google as part of the polymer project is also subject to an additional IP
 * rights grant found at http://polymer.github.io/PATENTS.txt
 */
export default class DocumentConstructionObserver {
    constructor(internals, doc) {
        this._observer = undefined;
        this._internals = internals;
        this._document = doc;
        // Simulate tree construction for all currently accessible nodes in the
        // document.
        this._internals.patchAndUpgradeTree(this._document);
        if (this._document.readyState === 'loading') {
            this._observer = new MutationObserver(this._handleMutations.bind(this));
            // Nodes created by the parser are given to the observer *before* the next
            // task runs. Inline scripts are run in a new task. This means that the
            // observer will be able to handle the newly parsed nodes before the
            // inline script is run.
            this._observer.observe(this._document, {
                childList: true,
                subtree: true,
            });
        }
    }
    disconnect() {
        if (this._observer) {
            this._observer.disconnect();
        }
    }
    _handleMutations(mutations) {
        // Once the document's `readyState` is 'interactive' or 'complete', all new
        // nodes created within that document will be the result of script and
        // should be handled by patching.
        const readyState = this._document.readyState;
        if (readyState === 'interactive' || readyState === 'complete') {
            this.disconnect();
        }
        for (let i = 0; i < mutations.length; i++) {
            const addedNodes = mutations[i].addedNodes;
            for (let j = 0; j < addedNodes.length; j++) {
                const node = addedNodes[j];
                this._internals.patchAndUpgradeTree(node);
            }
        }
    }
}
//# sourceMappingURL=DocumentConstructionObserver.js.map