/**
 * An options object to update and start the server.
 */
export interface Options {
    browserDrivers?: BrowserDriver[];
    server?: Server;
    proxy?: string;
    ignoreSSL?: boolean;
    outDir?: string;
    githubToken?: string;
}
/**
 * Contains information about a browser driver.
 */
export interface BrowserDriver {
    name?: 'chromedriver' | 'geckodriver' | 'iedriver';
    version?: string;
}
/**
 * Contains information about the selenium server standalone. This includes
 * options to start the server along with options to send to the server.
 */
export interface Server {
    name?: 'selenium';
    version?: string;
    runAsNode?: boolean;
    chromeLogs?: string;
    edge?: string;
    runAsDetach?: boolean;
    port?: number;
}
