"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const loglevel = require("loglevel");
const selenium_server_1 = require("../provider/selenium_server");
const utils_1 = require("./utils");
const log = loglevel.getLogger('webdriver-manager');
/**
 * Handles making the get request to stop the selenium server standalone if the
 * server has been started with role = node.
 * @param argv The argv from yargs.
 */
async function handler(argv) {
    log.setLevel(argv.log_level);
    const seleniumServer = new selenium_server_1.SeleniumServer();
    seleniumServer.runAsNode = true;
    const options = { server: { name: 'selenium', runAsNode: true } };
    await shutdown(options);
}
exports.handler = handler;
/**
 * Shutdown the selenium server with a get request. If the server is not
 * started with role = node, nothing will happen.
 * @param options The constructed option for the server.
 * @returns A promise for the get request.
 */
function shutdown(options) {
    const optionsBinary = utils_1.addOptionsBinary(options);
    return shutdownBinary(optionsBinary);
}
exports.shutdown = shutdown;
/**
 * Shutodown the selenium server with a get request. If the server is not
 * started with role = node, nothing will happen.
 * @param optionsBinary The constructed option for the server with binary.
 * @returns A promise for the get request.
 */
function shutdownBinary(optionsBinary) {
    const seleniumServer = optionsBinary.server.binary;
    return seleniumServer.stopServer();
}
exports.shutdownBinary = shutdownBinary;
//# sourceMappingURL=shutdown.js.map