"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const loglevel = require("loglevel");
const utils_1 = require("./utils");
const log = loglevel.getLogger('webdriver-manager');
/**
 * Displays which versions of providers that have been downloaded.
 * @param argv The argv from yargs.
 */
function handler(argv) {
    log.setLevel(argv.log_level);
    const options = utils_1.convertArgs2AllOptions(argv);
    console.log(status(options));
}
exports.handler = handler;
/**
 * Gets a list of versions for server and browser drivers.
 * @param options The constructed set of all options.
 * @returns A string of the versions downloaded.
 */
function status(options) {
    const optionsBinary = utils_1.addOptionsBinary(options);
    return statusBinary(optionsBinary);
}
exports.status = status;
/**
 * Gets a list of versions for server and browser drivers.
 * @param optionsBinary The constructed set of all options with binaries.
 * @returns A string of the versions downloaded.
 */
function statusBinary(optionsBinary) {
    const binaryVersions = [];
    for (const browserDriver of optionsBinary.browserDrivers) {
        const status = browserDriver.binary.getStatus();
        if (status) {
            binaryVersions.push(`${browserDriver.name}: ${status}`);
        }
    }
    if (optionsBinary.server && optionsBinary.server.binary) {
        const status = optionsBinary.server.binary.getStatus();
        if (status) {
            binaryVersions.push(`${optionsBinary.server.name}: ${status}`);
        }
    }
    return (binaryVersions.sort()).join('\n');
}
exports.statusBinary = statusBinary;
//# sourceMappingURL=status.js.map