"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const loglevel = require("loglevel");
const utils_1 = require("./utils");
const log = loglevel.getLogger('webdriver-manager');
/**
 * Updates / downloads the providers binaries.
 * @param argv The argv from yargs.
 */
async function handler(argv) {
    log.setLevel(argv.log_level);
    const options = utils_1.convertArgs2Options(argv);
    await update(options);
}
exports.handler = handler;
/**
 * Updates / downloads the providers binaries.
 * @param options The constructed options.
 * @returns Promise when binaries are all downloaded.
 */
function update(options) {
    const optionsBinary = utils_1.addOptionsBinary(options);
    return updateBinary(optionsBinary);
}
exports.update = update;
/**
 * Updates / downloads the providers binaries.
 * @param optionsBinary The constructed options with binaries.
 * @returns Promise when binaries are all downloaded.
 */
function updateBinary(optionsBinary) {
    const promises = [];
    if (optionsBinary.browserDrivers) {
        for (const provider of optionsBinary.browserDrivers) {
            promises.push(provider.binary.updateBinary(provider.version));
        }
    }
    if (optionsBinary.server && optionsBinary.server.binary) {
        promises.push(optionsBinary.server.binary.updateBinary(optionsBinary.server.version));
    }
    return Promise.all(promises);
}
exports.updateBinary = updateBinary;
//# sourceMappingURL=update.js.map