"use strict";
// Exports when using this module as a dependency.
Object.defineProperty(exports, "__esModule", { value: true });
// Expose the loglevel api.
const loglevel = require("loglevel");
exports.setLogLevel = loglevel.getLogger('webdriver-manager').setLevel;
// Export commands used in the cli.
var clean_1 = require("./cmds/clean");
exports.clean = clean_1.clean;
var shutdown_1 = require("./cmds/shutdown");
exports.shutdown = shutdown_1.shutdown;
var start_1 = require("./cmds/start");
exports.start = start_1.start;
var status_1 = require("./cmds/status");
exports.status = status_1.status;
var update_1 = require("./cmds/update");
exports.update = update_1.update;
var chromedriver_1 = require("./provider/chromedriver");
exports.ChromeDriver = chromedriver_1.ChromeDriver;
var geckodriver_1 = require("./provider/geckodriver");
exports.GeckoDriver = geckodriver_1.GeckoDriver;
var iedriver_1 = require("./provider/iedriver");
exports.IEDriver = iedriver_1.IEDriver;
var selenium_server_1 = require("./provider/selenium_server");
exports.SeleniumServer = selenium_server_1.SeleniumServer;
//# sourceMappingURL=index.js.map