import { ProviderConfig, ProviderInterface } from './provider';
export declare class Appium implements ProviderInterface {
    ignoreSSL: boolean;
    outDir: string;
    outDirAppium: string;
    proxy: string;
    requestUrl: string;
    constructor(providerConfig?: ProviderConfig);
    /**
     * If no valid version is provided get version from appium
     */
    getVersion(): Promise<string>;
    /**
     * Creates appium directory and package.json file.
     * @param version Optional to provide the version number or latest.
     */
    setup(version?: string): Promise<void>;
    /**
     * Creates an appium/package.json file and installs the appium dependency.
     * @param version Optional to provide the version number or latest.
     */
    updateBinary(version?: string): Promise<void>;
}
