export declare const OUT_DIR: string;
/**
 * The provider updateBinary interface implemented by all providers.
 */
export interface ProviderInterface {
    cleanFiles?: () => string;
    getBinaryPath?: (version?: string) => string | null;
    getStatus?: () => string | null;
    updateBinary: (version?: string) => Promise<void>;
    seleniumFlag?: string;
    osType?: string;
}
/**
 * The provider configuration is passed to the Provider and can override
 * the default behavior of the provider.
 */
export interface ProviderConfig {
    requestUrl?: string;
    outDir?: string;
    cacheFileName?: string;
    configFileName?: string;
    osType?: string;
    osArch?: string;
    proxy?: string;
    ignoreSSL?: boolean;
    [key: string]: string | boolean | number;
}
