import { HttpOptions, JsonObject } from './http_utils';
import { VersionList } from './version_list';
/**
 * Read the xml file from cache. If the cache time has been exceeded or the
 * file does not exist, make an http request and write it to the file.
 * @param xmlUrl The xml url.
 * @param httpOptions The http options for the request.
 */
export declare function updateXml(xmlUrl: string, httpOptions: HttpOptions): Promise<JsonObject>;
/**
 * Returns a list of versions and the partial url paths.
 * @param fileName the location of the xml file to read.
 * @returns the version list from the xml file.
 */
export declare function convertXmlToVersionList(fileName: string, matchFile: string, versionParser: (key: string) => string | null, semanticVersionParser: (key: string) => string): VersionList | null;
