"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const semver = require("semver");
const file_utils_1 = require("./file_utils");
const file_utils_2 = require("./file_utils");
const http_utils_1 = require("./http_utils");
/**
 * Read the xml file from cache. If the cache time has been exceeded or the
 * file does not exist, make an http request and write it to the file.
 * @param xmlUrl The xml url.
 * @param httpOptions The http options for the request.
 */
async function updateXml(xmlUrl, httpOptions) {
    if (file_utils_2.isExpired(httpOptions.fileName)) {
        const contents = await http_utils_1.requestBody(xmlUrl, httpOptions);
        const dir = path.dirname(httpOptions.fileName);
        try {
            fs.mkdirSync(dir);
        }
        catch (err) {
        }
        fs.writeFileSync(httpOptions.fileName, contents);
        return file_utils_1.convertXml2js(contents);
    }
    else {
        return file_utils_1.readXml(httpOptions.fileName);
    }
}
exports.updateXml = updateXml;
/**
 * Returns a list of versions and the partial url paths.
 * @param fileName the location of the xml file to read.
 * @returns the version list from the xml file.
 */
function convertXmlToVersionList(fileName, matchFile, versionParser, semanticVersionParser) {
    const xmlJs = file_utils_1.readXml(fileName);
    if (!xmlJs) {
        return null;
    }
    const versionList = {};
    for (const content of xmlJs['ListBucketResult']['Contents']) {
        const key = content['Key'][0];
        if (key.includes(matchFile)) {
            const version = versionParser(key);
            if (version) {
                const semanticVersion = semanticVersionParser(key);
                if (!semver.valid(semanticVersion)) {
                    continue;
                }
                const name = key.split('/')[1];
                const size = +content['Size'][0];
                if (!versionList[semanticVersion]) {
                    versionList[semanticVersion] = {};
                }
                versionList[semanticVersion][name] = { name, size, url: key, version };
            }
        }
    }
    return versionList;
}
exports.convertXmlToVersionList = convertXmlToVersionList;
//# sourceMappingURL=cloud_storage_xml.js.map