/**
 * An object of multiple versions of a binary. Each version could have
 * different keys where each key represents a partial url path. Each
 * partial url path could represent a combination of os architecture
 * and os type.
 */
export interface VersionList {
    [forcedVersion: string]: {
        [name: string]: VersionObj;
    };
}
/**
 * Information about the binary file.
 */
export interface VersionObj {
    name?: string;
    size?: number;
    url?: string;
    version?: string;
}
/**
 * Encapsulates the getVersionObjs and getVersionObj into a single method.
 * @param versionList The version list object.
 * @param osMatch The OS name and architecture.
 * @param version Optional field for the semver version number or latest.
 * * @returns Either a VersionObj or null.
 */
export declare function getVersion(versionList: VersionList, osMatch: string, version?: string): VersionObj | null;
/**
 * Get the version obj from the version list.
 * @param versionList The version list object.
 * @param version Optional field for the semver version number or latest.
 * @returns The object with paritial urls associated with the binary size.
 */
export declare function getVersionObjs(versionList: VersionList, version?: string): {
    [key: string]: VersionObj;
};
/**
 * Get the version obj from the map.
 * @param versionObjs A map of partial urls to VersionObj
 * @param osMatch The OS name and architecture.
 * @returns Either a VersionObj or null.
 */
export declare function getVersionObj(versionObjMap: {
    [key: string]: VersionObj;
}, osMatch: string): VersionObj | null;
