var webpack = require("webpack");
var path = require('path');

var config = {
  entry: {
    "tests" : "./tests/suite.ts"
  },
  output: {
    path: path.join(__dirname, 'codebase'),
    publicPath:"/codebase/",
    filename: '[name].js'
  },
  devtool: 'inline-source-map',
  module: {
    rules: [
      {
        test: /\.ts$/,
        loader: 'ts-loader'
      }
    ]
  },
  resolve: {
    extensions: ['.ts', '.js'],
    modules: ["./sources", "./node_modules"]
  },
  plugins: [
    new webpack.IgnorePlugin(/^jet-views/),
    new webpack.IgnorePlugin(/^jet-locales/)
  ]
};

module.exports = config;