"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

const LEVELS = ['debug', 'info', 'warn', 'error', 'silent'];
const LEVEL_TO_CONSOLE_METHOD = new Map([['debug', 'log'], ['info', 'log'], ['warn', 'log']]);

class Logger {
  constructor(level = Logger.defaultLevel) {
    this.activeLevels = new Set();
    this.setLogLevel(level);
  }

  setLogLevel(level) {
    const levelIndex = LEVELS.indexOf(level);
    if (levelIndex === -1) throw new Error(`Invalid log level "${level}". Use one of these: ${LEVELS.join(', ')}`);
    this.activeLevels.clear();
    var _iteratorNormalCompletion = true;
    var _didIteratorError = false;
    var _iteratorError = undefined;

    try {
      for (var _iterator = LEVELS.entries()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
        const _step$value = (0, _slicedToArray2.default)(_step.value, 2),
              i = _step$value[0],
              level = _step$value[1];

        if (i >= levelIndex) this.activeLevels.add(level);
      }
    } catch (err) {
      _didIteratorError = true;
      _iteratorError = err;
    } finally {
      try {
        if (!_iteratorNormalCompletion && _iterator.return != null) {
          _iterator.return();
        }
      } finally {
        if (_didIteratorError) {
          throw _iteratorError;
        }
      }
    }
  }

  _log(level, ...args) {
    console[LEVEL_TO_CONSOLE_METHOD.get(level) || level](...args);
  }

}

Logger.levels = LEVELS;
Logger.defaultLevel = 'info';
;
LEVELS.forEach(level => {
  if (level === 'silent') return;

  Logger.prototype[level] = function (...args) {
    if (this.activeLevels.has(level)) this._log(level, ...args);
  };
});
module.exports = Logger;