'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var wildcard = _interopDefault(require('wildcard'));
var cloneDeep = _interopDefault(require('clone-deep'));

function mergeWith(objects, customizer) {
  var first = objects[0],
      rest = objects.slice(1);
  var ret = first;
  rest.forEach(function (a) {
    ret = mergeTo(ret, a, customizer);
  });
  return ret;
}

function mergeTo(a, b, customizer) {
  var ret = {};
  Object.keys(a).concat(Object.keys(b)).forEach(function (k) {
    var v = customizer(a[k], b[k], k);
    ret[k] = typeof v === "undefined" ? a[k] : v;
  });
  return ret;
}

var isArray = Array.isArray;
function joinArrays(_temp) {
  var _ref = _temp === void 0 ? {} : _temp,
      customizeArray = _ref.customizeArray,
      customizeObject = _ref.customizeObject,
      key = _ref.key;

  return function _joinArrays(a, b, k) {
    var newKey = key ? key + "." + k : k;

    if (isFunction(a) && isFunction(b)) {
      return function () {
        return _joinArrays(a.apply(void 0, arguments), b.apply(void 0, arguments), k);
      };
    }

    if (isArray(a) && isArray(b)) {
      var customResult = customizeArray && customizeArray(a, b, newKey);
      return customResult || [].concat(a, b);
    }

    if (isPlainObject(a) && isPlainObject(b)) {
      var _customResult = customizeObject && customizeObject(a, b, newKey);

      return _customResult || mergeWith([a, b], joinArrays({
        customizeArray: customizeArray,
        customizeObject: customizeObject,
        key: newKey
      }));
    }

    if (isPlainObject(b)) {
      return cloneDeep(b);
    }

    if (isArray(b)) {
      return [].concat(b);
    }

    return b;
  };
} // https://stackoverflow.com/a/7356528/228885

function isFunction(functionToCheck) {
  return functionToCheck && {}.toString.call(functionToCheck) === "[object Function]";
}

function isPlainObject(a) {
  return typeof a === "object";
}

function mergeUnique(key, uniques, getter) {
  return function (a, b, k) {
    return k === key && [].concat(difference(a, b, function (item) {
      return uniques.indexOf(getter(item));
    }), b);
  };
}

function difference(a, b, cb) {
  var ret = a.filter(function (v, i) {
    var foundA = cb(v);
    var foundB = cb(b[i] || {});

    if (foundA >= 0 && foundB >= 0) {
      return foundA !== foundB;
    }

    return true;
  });
  return ret;
}

var CustomizeRule;

(function (CustomizeRule) {
  CustomizeRule["Append"] = "append";
  CustomizeRule["Prepend"] = "prepend";
  CustomizeRule["Replace"] = "replace";
})(CustomizeRule || (CustomizeRule = {}));

function merge(firstConfiguration) {
  for (var _len = arguments.length, configurations = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    configurations[_key - 1] = arguments[_key];
  }

  return mergeWithCustomize({}).apply(void 0, [firstConfiguration].concat(configurations));
}

function mergeWithCustomize(options) {
  return function mergeWithOptions(firstConfiguration) {
    // @ts-ignore
    if (firstConfiguration.then) {
      throw new TypeError("Promises are not supported");
    }

    for (var _len2 = arguments.length, configurations = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
      configurations[_key2 - 1] = arguments[_key2];
    }

    if (configurations.length === 0) {
      if (Array.isArray(firstConfiguration)) {
        // @ts-ignore
        if (firstConfiguration[0].then) {
          throw new TypeError("Promises are not supported");
        }

        return mergeWith(firstConfiguration, joinArrays(options));
      }

      return firstConfiguration;
    }

    return mergeWith([firstConfiguration].concat(configurations), joinArrays(options));
  };
}

function customizeArray(rules) {
  return function (a, b, key) {
    var match = Object.keys(rules).find(function (rule) {
      return wildcard(rule, key);
    }) || "";

    switch (rules[match]) {
      case CustomizeRule.Prepend:
        return [].concat(b, a);

      case CustomizeRule.Replace:
        return b;

      case CustomizeRule.Append:
      default:
        return [].concat(a, b);
    }
  };
}

function customizeObject(rules) {
  return function (a, b, key) {
    switch (rules[key]) {
      case CustomizeRule.Prepend:
        return mergeWith([b, a], joinArrays());

      case CustomizeRule.Replace:
        return b;

      case CustomizeRule.Append:
        return mergeWith([a, b], joinArrays());
    }
  };
}

exports.customizeArray = customizeArray;
exports.customizeObject = customizeObject;
exports.merge = merge;
exports.mergeWithCustomize = mergeWithCustomize;
exports.unique = mergeUnique;
//# sourceMappingURL=webpack-merge.cjs.development.js.map
