exports.connectChunkGroupAndChunk = (chunkGroup, chunk) => {
	if(chunkGroup.pushChunk(chunk)) {
		chunk.addGroup(chunkGroup);
	}
};

exports.connectChunkGroupParentAndChild = (parent, child) => {
	if(parent.addChild(child)) {
		child.addParent(parent);
	}
};

exports.connectChunkAndModule = (chunk, module) => {
	if(module.addChunk(chunk)) {
		chunk.addModule(module);
	}
};

exports.disconnectChunkAndModule = (chunk, module) => {
	chunk.removeModule(module);
	module.removeChunk(chunk);
};

exports.connectDependenciesBlockAndChunkGroup = (depBlock, chunkGroup) => {
	if(chunkGroup.addBlock(depBlock)) {
		depBlock.chunkGroup = chunkGroup;
	}
};
