/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
"use strict";

const JsonParser = require("./JsonParser");
const JsonGenerator = require("./JsonGenerator");

class JsonModulesPlugin {
	apply(compiler) {
		compiler.hooks.compilation.tap("JsonModulesPlugin", (compilation, {
			normalModuleFactory
		}) => {
			normalModuleFactory.hooks.createParser.for("json").tap("JsonModulesPlugin", () => {
				return new JsonParser();
			});
			normalModuleFactory.hooks.createGenerator.for("json").tap("JsonModulesPlugin", () => {
				return new JsonGenerator();
			});
		});
	}
}

module.exports = JsonModulesPlugin;
