import { Def } from './def.enum.js';
/**
 * @link https://docs.microsoft.com/en-us/windows/win32/secauthz/access-mask-format
 */
export declare const ACCESS_MASK = Def.int32;
export declare const ATOM = Def.uint16;
export declare const DWORD = Def.uint32;
export declare const PVOID: Def;
/**
 * `uint32` or `uint64` used as value usage (memory address) instead of PVOID (Buffer),
 * Use `HANDLE` (number) for params defintion of the api,
 * @see https://stackoverflow.com/questions/18266626/what-is-the-range-of-a-windows-handle-on-a-64-bits-application/29526711#29526711
 */
export declare const HANDLE: Def;
/**
 * `HANDLE_PVOID` (Buffer) can be used for definition of Struct,
 */
export declare const HANDLE_PVOID: Def;
export declare const LONG_PTR: Def;
export declare const ULONG_PTR: Def;
export declare const VOID = Def.void;
export declare const WCHAR = Def.uint16;
export declare const WORD = Def.int16;
export declare const BOOL = Def.int;
export declare const BOOLEAN = Def.bool;
export declare const BYTE = Def.byte;
export declare const CALLBACK = Def.ptr;
export declare const CCHAR = Def.uint8;
export declare const CHAR = Def.uint8;
export declare const COLORREF = Def.uint32;
export declare const DWORDLONG = Def.uint64;
export declare const DWORD_PTR: Def;
export declare const DWORD32 = Def.uint32;
export declare const DWORD64 = Def.uint64;
export declare const FLOAT = Def.float;
export declare const HACCEL: Def;
export declare const HALF_PTR: Def;
export declare const HBITMAP: Def;
export declare const HBRUSH: Def;
export declare const HCOLORSPACE: Def;
export declare const HCONV: Def;
export declare const HCONVLIST: Def;
export declare const HCURSOR: Def;
export declare const HDC: Def;
export declare const HDDEDATA: Def;
export declare const HDESK: Def;
export declare const HDROP: Def;
export declare const HDWP: Def;
export declare const HENHMETAFILE: Def;
export declare const HFILE: Def;
export declare const HFONT: Def;
export declare const HGDIOBJ: Def;
export declare const HGLOBAL: Def;
export declare const HHOOK: Def;
export declare const HICON: Def;
export declare const HINSTANCE: Def;
export declare const HKEY: Def;
export declare const HKL: Def;
export declare const HLOCAL: Def;
export declare const HMENU: Def;
export declare const HMETAFILE: Def;
export declare const HMODULE: Def;
export declare const HMONITOR: Def;
export declare const HPALETTE: Def;
export declare const HPEN: Def;
export declare const HRESULT = Def.long;
export declare const HRGN: Def;
export declare const HRSRC: Def;
export declare const HSZ: Def;
export declare const HWINEVENTHOOK: Def;
export declare const HWINSTA: Def;
export declare const HWND: Def;
/** A 32-bit signed integer */
export declare const INT = Def.int;
export declare const INT_PTR: Def;
export declare const INT8 = Def.int8;
export declare const INT16 = Def.int16;
export declare const INT32 = Def.int32;
export declare const INT64 = Def.int64;
export declare const LANGID = Def.int16;
export declare const LCID = Def.uint32;
export declare const LCTYPE = Def.uint32;
export declare const LGRPID = Def.uint32;
export declare const LONG = Def.long;
export declare const LONGLONG = Def.longlong;
export declare const LONG32 = Def.int32;
export declare const LONG64 = Def.int64;
export declare const LPARAM: Def;
export declare const LPBOOL = Def.int;
export declare const LPBYTE = Def.bytePtr;
export declare const LPCOLORREF = Def.uint32;
export declare const LPCSTR = Def.uint8Ptr;
export declare const LPCWSTR = Def.uint16Ptr;
export declare const LPCTSTR = Def.uint16Ptr;
export declare const LPVOID = Def.voidPtr;
export declare const LPCVOID = Def.voidPtr;
export declare const LPDWORD = Def.uint16Ptr;
export declare const LPHANDLE: Def;
export declare const LPINT = Def.intPtr;
export declare const LPLONG = Def.int32Ptr;
export declare const LPMSG = Def.ptr;
export declare const LPPOINT = Def.ptr;
export declare const LPSTR = Def.charPtr;
export declare const LPWSTR = Def.uint16Ptr;
export declare const LPTSTR = Def.uint16Ptr;
export declare const LPWORD = Def.uint16Ptr;
export declare const LRESULT: Def;
export declare const NTSTATUS = Def.uint32;
export declare const PBOOL = Def.intPtr;
export declare const PBOOLEAN = Def.boolPtr;
export declare const PBYTE = Def.bytePtr;
export declare const PCHAR = Def.charPtr;
export declare const PCSTR = Def.uint8Ptr;
export declare const PCTSTR: Def;
export declare const PCWSTR = Def.uint16Ptr;
export declare const PDWORD = Def.uint32Ptr;
export declare const PDWORDLONG = Def.uint64Ptr;
export declare const PDWORD_PTR: Def;
export declare const PDWORD32 = Def.uint32Ptr;
export declare const PDWORD64 = Def.uint64Ptr;
export declare const PFLOAT = Def.floatPtr;
export declare const PHALF_PTR = Def.ptr;
export declare const PHANDLE: Def;
export declare const PHKEY: Def;
export declare const PINT = Def.intPtr;
export declare const PINT_PTR = Def.intPtrPtr;
export declare const PINT8 = Def.int8Ptr;
export declare const PINT16 = Def.int16Ptr;
export declare const PINT32 = Def.int32Ptr;
export declare const PINT64 = Def.int64Ptr;
export declare const PLCID = Def.uint32Ptr;
export declare const PLONG = Def.longPtr;
export declare const PLONGLONG = Def.int64Ptr;
export declare const PLONG_PTR = Def.ptr;
export declare const PLONG32 = Def.int32Ptr;
export declare const PLONG64 = Def.int64Ptr;
export declare const POINTER_32 = Def.int32Ptr;
export declare const POINTER_64: Def;
export declare const POINTER_SIGNED = Def.ptr;
export declare const POINTER_UNSIGNED = Def.ptr;
export declare const PSHORT = Def.int16Ptr;
export declare const PSIZE_T: Def;
export declare const PSSIZE_T = Def.ptr;
export declare const PSTR = Def.charPtr;
export declare const PTBYTE = Def.int16Ptr;
export declare const PTCHAR = Def.uint16Ptr;
export declare const PTSTR = Def.uint16Ptr;
export declare const PUCHAR = Def.ptr;
export declare const PUHALF_PTR = Def.ptr;
export declare const PUINT = Def.uintPtr;
export declare const PUINT_PTR = Def.uintPtrPtr;
export declare const PUINT8 = Def.uint8Ptr;
export declare const PUINT16 = Def.uint16Ptr;
export declare const PUINT32 = Def.uint32Ptr;
export declare const PUINT64 = Def.uint64Ptr;
export declare const PULONG = Def.uintPtr;
export declare const PULONGLONG = Def.uint64Ptr;
export declare const PULONG_PTR = Def.uint64PtrPtr;
export declare const PULONG32 = Def.uintPtr;
export declare const PULONG64 = Def.uint64Ptr;
export declare const PUSHORT = Def.uint16Ptr;
export declare const PWCHAR = Def.uint16Ptr;
export declare const PWORD = Def.uint16Ptr;
export declare const PWSTR = Def.uint16Ptr;
export declare const QWORD = Def.uint64;
export declare const SC_HANDLE: Def;
export declare const SC_LOCK = Def.voidPtr;
export declare const SERVICE_STATUS_HANDLE: Def;
export declare const SHORT = Def.int16;
export declare const SIZE_T: Def;
export declare const SSIZE_T: Def;
export declare const TBYTE = Def.int16;
export declare const TCHAR = Def.uint16;
export declare const UCHAR = Def.uchar;
export declare const UHALF_PTR: Def;
export declare const UINT = Def.uint;
export declare const UINT_PTR: Def;
export declare const UINT8 = Def.uint8;
export declare const UINT16 = Def.uint16;
export declare const UINT32 = Def.uint32;
export declare const UINT64 = Def.uint64;
export declare const ULONG = Def.uint;
export declare const ULONGLONG = Def.uint64;
export declare const ULONG32 = Def.uint32;
export declare const ULONG64 = Def.uint64;
export declare const USHORT = Def.ushort;
export declare const USN = Def.longlong;
export declare const WINEVENTPROC = Def.ptr;
export declare const WNDENUMPROC = Def.ptr;
export declare const WNDPROC = Def.ptr;
/**
 * Note: original be typedef UINT_PTR WPARAM;
 * CALLBACK WNDCLASSEX.lpfnWndProc may pass negative number and cause process exit.
 */
export declare const WPARAM: Def;
export declare const LPINITCOMMONCONTROLSEX = Def.ptr;
export declare const LPWNDCLASSEX = Def.ptr;
export declare const PWINDOWINFO = Def.ptr;
export declare const PFILETIME = Def.ptr;
export declare const LPFILETIME = Def.ptr;
export declare const va_list = Def.charPtr;
//# sourceMappingURL=common.def.d.ts.map