/*! window-post-message-proxy v0.2.5 | (c) 2016 Microsoft Corporation MIT */
export interface ITrackingProperties {
    id: string;
}
export interface IAddTrackingProperties {
    <T>(message: T, trackingProperties: ITrackingProperties): T;
}
export interface IGetTrackingProperties {
    (message: any): ITrackingProperties;
}
export interface IProcessTrackingProperties {
    addTrackingProperties: IAddTrackingProperties;
    getTrackingProperties: IGetTrackingProperties;
}
export interface IIsErrorMessage {
    (message: any): boolean;
}
export interface IMessageHandler {
    test(message: any): boolean;
    handle(message: any): any;
}
export interface IWindowPostMessageProxyOptions {
    receiveWindow?: Window;
    processTrackingProperties?: IProcessTrackingProperties;
    isErrorMessage?: IIsErrorMessage;
    name?: string;
    logMessages?: boolean;
    eventSourceOverrideWindow?: Window;
    suppressWarnings?: boolean;
}
export declare class WindowPostMessageProxy {
    static defaultAddTrackingProperties<T>(message: T, trackingProperties: ITrackingProperties): T;
    static defaultGetTrackingProperties(message: any): ITrackingProperties;
    static defaultIsErrorMessage(message: any): boolean;
    private static messagePropertyName;
    /**
     * Utility to create a deferred object.
     */
    private static createDeferred();
    /**
     * Utility to generate random sequence of characters used as tracking id for promises.
     */
    private static createRandomString();
    private logMessages;
    private name;
    private addTrackingProperties;
    private getTrackingProperties;
    private isErrorMessage;
    private receiveWindow;
    private pendingRequestPromises;
    private handlers;
    private windowMessageHandler;
    private eventSourceOverrideWindow;
    private suppressWarnings;
    constructor(options?: IWindowPostMessageProxyOptions);
    /**
     * Adds handler.
     * If the first handler whose test method returns true will handle the message and provide a response.
     */
    addHandler(handler: IMessageHandler): void;
    /**
     * Removes handler.
     * The reference must match the original object that was provided when adding the handler.
     */
    removeHandler(handler: IMessageHandler): void;
    /**
     * Start listening to message events.
     */
    start(): void;
    /**
     * Stops listening to message events.
     */
    stop(): void;
    /**
     * Post message to target window with tracking properties added and save deferred object referenced by tracking id.
     */
    postMessage<T>(targetWindow: Window, message: any): Promise<T>;
    /**
     * Send response message to target window.
     * Response messages re-use tracking properties from a previous request message.
     */
    private sendResponse(targetWindow, message, trackingProperties);
    /**
     * Message handler.
     */
    private onMessageReceived(event);
}
