export declare type Observer<Event = void> = (event: Event) => void;
export declare type ObserverName = string | Symbol;
export interface Subject<Event = void> {
    addObserver(name: ObserverName, observer: Observer<Event>): this;
    deleteObserver(name: ObserverName): this;
    notifyObservers(event: Event): this;
    subscribe(): this;
    unsubscribe(): this;
}
export declare type WindowResizeObserver = Observer<WindowResizeSubjectEvent>;
export declare type WindowResizeSubjectEvent = {
    width: number;
    height: number;
};
export declare type WindowResizeSubjectOption = {
    delay?: number;
};
