'use strict';

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _slicedToArray2 = require('babel-runtime/helpers/slicedToArray');

var _slicedToArray3 = _interopRequireDefault(_slicedToArray2);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
**/

var assert = require('assert');
var ol = require('common-tags').oneLine;
var path = require('path');
var prettyBytes = require('pretty-bytes');
var workboxBuild = require('workbox-build');

var constants = require('./lib/constants');
var errors = require('./lib/errors');
var logger = require('./lib/logger');
var readConfig = require('./lib/read-config');
var runWizard = require('./lib/run-wizard');

module.exports = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
  var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var _params$input, _params$input$, command, option, parentDirectory, dirName, fullPath, configPath, config, _ref2, size, count, warnings, _iteratorNormalCompletion, _didIteratorError, _iteratorError, _iterator, _step, warning;

  return _regenerator2.default.wrap(function _callee$(_context) {
    while (1) {
      switch (_context.prev = _context.next) {
        case 0:
          // This should not be a user-visible error, unless meow() messes something up.
          assert(Array.isArray(params.input), errors['missing-input']);

          // Default to showing the help message if there's no command provided.
          _params$input = (0, _slicedToArray3.default)(params.input, 2), _params$input$ = _params$input[0], command = _params$input$ === undefined ? 'help' : _params$input$, option = _params$input[1];
          _context.t0 = command;
          _context.next = _context.t0 === 'wizard' ? 5 : _context.t0 === 'copyLibraries' ? 8 : _context.t0 === 'generateSW' ? 18 : _context.t0 === 'injectManifest' ? 18 : _context.t0 === 'help' ? 65 : 67;
          break;

        case 5:
          _context.next = 7;
          return runWizard(params.flags);

        case 7:
          return _context.abrupt('break', 68);

        case 8:
          assert(option, errors['missing-dest-dir-param']);
          parentDirectory = path.resolve(process.cwd(), option);
          _context.next = 12;
          return workboxBuild.copyWorkboxLibraries(parentDirectory);

        case 12:
          dirName = _context.sent;
          fullPath = path.join(parentDirectory, dirName);


          logger.log(`The Workbox libraries were copied to ${fullPath}`);
          logger.log(ol`Add a call to workbox.setConfig({modulePathPrefix: '...'})
        to your service worker to use these local libraries.`);
          logger.log(`See https://goo.gl/Fo9gPX for further documentation.`);
          return _context.abrupt('break', 68);

        case 18:
          // TODO: Confirm that this works with Windows paths.
          configPath = path.resolve(process.cwd(), option || constants.defaultConfigFile);
          config = void 0;
          _context.prev = 20;

          config = readConfig(configPath);
          _context.next = 28;
          break;

        case 24:
          _context.prev = 24;
          _context.t1 = _context['catch'](20);

          logger.error(errors['invalid-common-js-module']);
          throw _context.t1;

        case 28:

          logger.log(`Using configuration from ${configPath}.`);
          _context.prev = 29;
          _context.next = 32;
          return workboxBuild[command](config);

        case 32:
          _ref2 = _context.sent;
          size = _ref2.size;
          count = _ref2.count;
          warnings = _ref2.warnings;
          _iteratorNormalCompletion = true;
          _didIteratorError = false;
          _iteratorError = undefined;
          _context.prev = 39;


          for (_iterator = (0, _getIterator3.default)(warnings); !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            warning = _step.value;

            logger.warn(warning);
          }

          _context.next = 47;
          break;

        case 43:
          _context.prev = 43;
          _context.t2 = _context['catch'](39);
          _didIteratorError = true;
          _iteratorError = _context.t2;

        case 47:
          _context.prev = 47;
          _context.prev = 48;

          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }

        case 50:
          _context.prev = 50;

          if (!_didIteratorError) {
            _context.next = 53;
            break;
          }

          throw _iteratorError;

        case 53:
          return _context.finish(50);

        case 54:
          return _context.finish(47);

        case 55:
          logger.log(`The service worker was written to ${config.swDest}\n` + `${count} files will be precached, totalling ${prettyBytes(size)}.`);
          _context.next = 64;
          break;

        case 58:
          _context.prev = 58;
          _context.t3 = _context['catch'](29);

          if (!(typeof _context.t3.annotate === 'function')) {
            _context.next = 62;
            break;
          }

          throw new Error(`${errors['config-validation-failed']}\n${_context.t3.annotate()}`);

        case 62:
          logger.error(errors['workbox-build-runtime-error']);
          throw _context.t3;

        case 64:
          return _context.abrupt('break', 68);

        case 65:
          params.showHelp();
          return _context.abrupt('break', 68);

        case 67:
          throw new Error(errors['unknown-command'] + ` ` + command);

        case 68:
        case 'end':
          return _context.stop();
      }
    }
  }, _callee, undefined, [[20, 24], [29, 58], [39, 43, 47, 55], [48,, 50, 54]]);
}));