(function (global, factory) {
	typeof exports === 'object' && typeof module !== 'undefined' ? module.exports = factory(require('@workday/canvas-kit-react-common')) :
	typeof define === 'function' && define.amd ? define(['@workday/canvas-kit-react-common'], factory) :
	(global = global || self, (global['canvas-kit-css-icon'] = global['canvas-kit-css-icon'] || {}, global['canvas-kit-css-icon'].js = factory(global.canvasKitReactCommon)));
}(this, function (canvasKitReactCommon) { 'use strict';

	function createCommonjsModule(fn, module) {
		return module = { exports: {} }, fn(module, module.exports), module.exports;
	}

	var svgInjector = createCommonjsModule(function (module, exports) {
	/**
	 * SVGInjector v1.1.3 - Fast, caching, dynamic inline SVG DOM injection library
	 * https://github.com/iconic/SVGInjector
	 *
	 * Copyright (c) 2014-2015 Waybury <hello@waybury.com>
	 * @license MIT
	 */

	(function (window, document) {

	  // Environment
	  var isLocal = window.location.protocol === 'file:';
	  var hasSvgSupport = document.implementation.hasFeature('http://www.w3.org/TR/SVG11/feature#BasicStructure', '1.1');

	  function uniqueClasses(list) {
	    list = list.split(' ');

	    var hash = {};
	    var i = list.length;
	    var out = [];

	    while (i--) {
	      if (!hash.hasOwnProperty(list[i])) {
	        hash[list[i]] = 1;
	        out.unshift(list[i]);
	      }
	    }

	    return out.join(' ');
	  }

	  /**
	   * cache (or polyfill for <= IE8) Array.forEach()
	   * source: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach
	   */
	  var forEach = Array.prototype.forEach || function (fn, scope) {
	    if (this === void 0 || this === null || typeof fn !== 'function') {
	      throw new TypeError();
	    }

	    /* jshint bitwise: false */
	    var i, len = this.length >>> 0;
	    /* jshint bitwise: true */

	    for (i = 0; i < len; ++i) {
	      if (i in this) {
	        fn.call(scope, this[i], i, this);
	      }
	    }
	  };

	  // SVG Cache
	  var svgCache = {};

	  var injectCount = 0;
	  var injectedElements = [];

	  // Request Queue
	  var requestQueue = [];

	  // Script running status
	  var ranScripts = {};

	  var cloneSvg = function (sourceSvg) {
	    return sourceSvg.cloneNode(true);
	  };

	  var queueRequest = function (url, callback) {
	    requestQueue[url] = requestQueue[url] || [];
	    requestQueue[url].push(callback);
	  };

	  var processRequestQueue = function (url) {
	    for (var i = 0, len = requestQueue[url].length; i < len; i++) {
	      // Make these calls async so we avoid blocking the page/renderer
	      /* jshint loopfunc: true */
	      (function (index) {
	        setTimeout(function () {
	          requestQueue[url][index](cloneSvg(svgCache[url]));
	        }, 0);
	      })(i);
	      /* jshint loopfunc: false */
	    }
	  };

	  var loadSvg = function (url, callback) {
	    if (svgCache[url] !== undefined) {
	      if (svgCache[url] instanceof SVGSVGElement) {
	        // We already have it in cache, so use it
	        callback(cloneSvg(svgCache[url]));
	      }
	      else {
	        // We don't have it in cache yet, but we are loading it, so queue this request
	        queueRequest(url, callback);
	      }
	    }
	    else {

	      if (!window.XMLHttpRequest) {
	        callback('Browser does not support XMLHttpRequest');
	        return false;
	      }

	      // Seed the cache to indicate we are loading this URL already
	      svgCache[url] = {};
	      queueRequest(url, callback);

	      var httpRequest = new XMLHttpRequest();

	      httpRequest.onreadystatechange = function () {
	        // readyState 4 = complete
	        if (httpRequest.readyState === 4) {

	          // Handle status
	          if (httpRequest.status === 404 || httpRequest.responseXML === null) {
	            callback('Unable to load SVG file: ' + url);

	            if (isLocal) callback('Note: SVG injection ajax calls do not work locally without adjusting security setting in your browser. Or consider using a local webserver.');

	            callback();
	            return false;
	          }

	          // 200 success from server, or 0 when using file:// protocol locally
	          if (httpRequest.status === 200 || (isLocal && httpRequest.status === 0)) {

	            /* globals Document */
	            if (httpRequest.responseXML instanceof Document) {
	              // Cache it
	              svgCache[url] = httpRequest.responseXML.documentElement;
	            }
	            /* globals -Document */

	            // IE9 doesn't create a responseXML Document object from loaded SVG,
	            // and throws a "DOM Exception: HIERARCHY_REQUEST_ERR (3)" error when injected.
	            //
	            // So, we'll just create our own manually via the DOMParser using
	            // the the raw XML responseText.
	            //
	            // :NOTE: IE8 and older doesn't have DOMParser, but they can't do SVG either, so...
	            else if (DOMParser && (DOMParser instanceof Function)) {
	              var xmlDoc;
	              try {
	                var parser = new DOMParser();
	                xmlDoc = parser.parseFromString(httpRequest.responseText, 'text/xml');
	              }
	              catch (e) {
	                xmlDoc = undefined;
	              }

	              if (!xmlDoc || xmlDoc.getElementsByTagName('parsererror').length) {
	                callback('Unable to parse SVG file: ' + url);
	                return false;
	              }
	              else {
	                // Cache it
	                svgCache[url] = xmlDoc.documentElement;
	              }
	            }

	            // We've loaded a new asset, so process any requests waiting for it
	            processRequestQueue(url);
	          }
	          else {
	            callback('There was a problem injecting the SVG: ' + httpRequest.status + ' ' + httpRequest.statusText);
	            return false;
	          }
	        }
	      };

	      httpRequest.open('GET', url);

	      // Treat and parse the response as XML, even if the
	      // server sends us a different mimetype
	      if (httpRequest.overrideMimeType) httpRequest.overrideMimeType('text/xml');

	      httpRequest.send();
	    }
	  };

	  // Inject a single element
	  var injectElement = function (el, evalScripts, pngFallback, callback) {

	    // Grab the src or data-src attribute
	    var imgUrl = el.getAttribute('data-src') || el.getAttribute('src');

	    // We can only inject SVG
	    if (!(/\.svg/i).test(imgUrl)) {
	      callback('Attempted to inject a file with a non-svg extension: ' + imgUrl);
	      return;
	    }

	    // If we don't have SVG support try to fall back to a png,
	    // either defined per-element via data-fallback or data-png,
	    // or globally via the pngFallback directory setting
	    if (!hasSvgSupport) {
	      var perElementFallback = el.getAttribute('data-fallback') || el.getAttribute('data-png');

	      // Per-element specific PNG fallback defined, so use that
	      if (perElementFallback) {
	        el.setAttribute('src', perElementFallback);
	        callback(null);
	      }
	      // Global PNG fallback directoriy defined, use the same-named PNG
	      else if (pngFallback) {
	        el.setAttribute('src', pngFallback + '/' + imgUrl.split('/').pop().replace('.svg', '.png'));
	        callback(null);
	      }
	      // um...
	      else {
	        callback('This browser does not support SVG and no PNG fallback was defined.');
	      }

	      return;
	    }

	    // Make sure we aren't already in the process of injecting this element to
	    // avoid a race condition if multiple injections for the same element are run.
	    // :NOTE: Using indexOf() only _after_ we check for SVG support and bail,
	    // so no need for IE8 indexOf() polyfill
	    if (injectedElements.indexOf(el) !== -1) {
	      return;
	    }

	    // Remember the request to inject this element, in case other injection
	    // calls are also trying to replace this element before we finish
	    injectedElements.push(el);

	    // Try to avoid loading the orginal image src if possible.
	    el.setAttribute('src', '');

	    // Load it up
	    loadSvg(imgUrl, function (svg) {

	      if (typeof svg === 'undefined' || typeof svg === 'string') {
	        callback(svg);
	        return false;
	      }

	      var imgId = el.getAttribute('id');
	      if (imgId) {
	        svg.setAttribute('id', imgId);
	      }

	      var imgTitle = el.getAttribute('title');
	      if (imgTitle) {
	        svg.setAttribute('title', imgTitle);
	      }

	      // Concat the SVG classes + 'injected-svg' + the img classes
	      var classMerge = [].concat(svg.getAttribute('class') || [], 'injected-svg', el.getAttribute('class') || []).join(' ');
	      svg.setAttribute('class', uniqueClasses(classMerge));

	      var imgStyle = el.getAttribute('style');
	      if (imgStyle) {
	        svg.setAttribute('style', imgStyle);
	      }

	      // Copy all the data elements to the svg
	      var imgData = [].filter.call(el.attributes, function (at) {
	        return (/^data-\w[\w\-]*$/).test(at.name);
	      });
	      forEach.call(imgData, function (dataAttr) {
	        if (dataAttr.name && dataAttr.value) {
	          svg.setAttribute(dataAttr.name, dataAttr.value);
	        }
	      });

	      // Make sure any internally referenced clipPath ids and their
	      // clip-path references are unique.
	      //
	      // This addresses the issue of having multiple instances of the
	      // same SVG on a page and only the first clipPath id is referenced.
	      //
	      // Browsers often shortcut the SVG Spec and don't use clipPaths
	      // contained in parent elements that are hidden, so if you hide the first
	      // SVG instance on the page, then all other instances lose their clipping.
	      // Reference: https://bugzilla.mozilla.org/show_bug.cgi?id=376027

	      // Handle all defs elements that have iri capable attributes as defined by w3c: http://www.w3.org/TR/SVG/linking.html#processingIRI
	      // Mapping IRI addressable elements to the properties that can reference them:
	      var iriElementsAndProperties = {
	        'clipPath': ['clip-path'],
	        'color-profile': ['color-profile'],
	        'cursor': ['cursor'],
	        'filter': ['filter'],
	        'linearGradient': ['fill', 'stroke'],
	        'marker': ['marker', 'marker-start', 'marker-mid', 'marker-end'],
	        'mask': ['mask'],
	        'pattern': ['fill', 'stroke'],
	        'radialGradient': ['fill', 'stroke']
	      };

	      var element, elementDefs, properties, currentId, newId;
	      Object.keys(iriElementsAndProperties).forEach(function (key) {
	        element = key;
	        properties = iriElementsAndProperties[key];

	        elementDefs = svg.querySelectorAll('defs ' + element + '[id]');
	        for (var i = 0, elementsLen = elementDefs.length; i < elementsLen; i++) {
	          currentId = elementDefs[i].id;
	          newId = currentId + '-' + injectCount;

	          // All of the properties that can reference this element type
	          var referencingElements;
	          forEach.call(properties, function (property) {
	            // :NOTE: using a substring match attr selector here to deal with IE "adding extra quotes in url() attrs"
	            referencingElements = svg.querySelectorAll('[' + property + '*="' + currentId + '"]');
	            for (var j = 0, referencingElementLen = referencingElements.length; j < referencingElementLen; j++) {
	              referencingElements[j].setAttribute(property, 'url(#' + newId + ')');
	            }
	          });

	          elementDefs[i].id = newId;
	        }
	      });

	      // Remove any unwanted/invalid namespaces that might have been added by SVG editing tools
	      svg.removeAttribute('xmlns:a');

	      // Post page load injected SVGs don't automatically have their script
	      // elements run, so we'll need to make that happen, if requested

	      // Find then prune the scripts
	      var scripts = svg.querySelectorAll('script');
	      var scriptsToEval = [];
	      var script, scriptType;

	      for (var k = 0, scriptsLen = scripts.length; k < scriptsLen; k++) {
	        scriptType = scripts[k].getAttribute('type');

	        // Only process javascript types.
	        // SVG defaults to 'application/ecmascript' for unset types
	        if (!scriptType || scriptType === 'application/ecmascript' || scriptType === 'application/javascript') {

	          // innerText for IE, textContent for other browsers
	          script = scripts[k].innerText || scripts[k].textContent;

	          // Stash
	          scriptsToEval.push(script);

	          // Tidy up and remove the script element since we don't need it anymore
	          svg.removeChild(scripts[k]);
	        }
	      }

	      // Run/Eval the scripts if needed
	      if (scriptsToEval.length > 0 && (evalScripts === 'always' || (evalScripts === 'once' && !ranScripts[imgUrl]))) {
	        for (var l = 0, scriptsToEvalLen = scriptsToEval.length; l < scriptsToEvalLen; l++) {

	          // :NOTE: Yup, this is a form of eval, but it is being used to eval code
	          // the caller has explictely asked to be loaded, and the code is in a caller
	          // defined SVG file... not raw user input.
	          //
	          // Also, the code is evaluated in a closure and not in the global scope.
	          // If you need to put something in global scope, use 'window'
	          new Function(scriptsToEval[l])(window); // jshint ignore:line
	        }

	        // Remember we already ran scripts for this svg
	        ranScripts[imgUrl] = true;
	      }

	      // :WORKAROUND:
	      // IE doesn't evaluate <style> tags in SVGs that are dynamically added to the page.
	      // This trick will trigger IE to read and use any existing SVG <style> tags.
	      //
	      // Reference: https://github.com/iconic/SVGInjector/issues/23
	      var styleTags = svg.querySelectorAll('style');
	      forEach.call(styleTags, function (styleTag) {
	        styleTag.textContent += '';
	      });

	      // Replace the image with the svg
	      el.parentNode.replaceChild(svg, el);

	      // Now that we no longer need it, drop references
	      // to the original element so it can be GC'd
	      delete injectedElements[injectedElements.indexOf(el)];
	      el = null;

	      // Increment the injected count
	      injectCount++;

	      callback(svg);
	    });
	  };

	  /**
	   * SVGInjector
	   *
	   * Replace the given elements with their full inline SVG DOM elements.
	   *
	   * :NOTE: We are using get/setAttribute with SVG because the SVG DOM spec differs from HTML DOM and
	   * can return other unexpected object types when trying to directly access svg properties.
	   * ex: "className" returns a SVGAnimatedString with the class value found in the "baseVal" property,
	   * instead of simple string like with HTML Elements.
	   *
	   * @param {mixes} Array of or single DOM element
	   * @param {object} options
	   * @param {function} callback
	   * @return {object} Instance of SVGInjector
	   */
	  var SVGInjector = function (elements, options, done) {

	    // Options & defaults
	    options = options || {};

	    // Should we run the scripts blocks found in the SVG
	    // 'always' - Run them every time
	    // 'once' - Only run scripts once for each SVG
	    // [false|'never'] - Ignore scripts
	    var evalScripts = options.evalScripts || 'always';

	    // Location of fallback pngs, if desired
	    var pngFallback = options.pngFallback || false;

	    // Callback to run during each SVG injection, returning the SVG injected
	    var eachCallback = options.each;

	    // Do the injection...
	    if (elements.length !== undefined) {
	      var elementsLoaded = 0;
	      forEach.call(elements, function (element) {
	        injectElement(element, evalScripts, pngFallback, function (svg) {
	          if (eachCallback && typeof eachCallback === 'function') eachCallback(svg);
	          if (done && elements.length === ++elementsLoaded) done(elementsLoaded);
	        });
	      });
	    }
	    else {
	      if (elements) {
	        injectElement(elements, evalScripts, pngFallback, function (svg) {
	          if (eachCallback && typeof eachCallback === 'function') eachCallback(svg);
	          if (done) done(1);
	          elements = null;
	        });
	      }
	      else {
	        if (done) done(0);
	      }
	    }
	  };

	  /* global module, exports: true, define */
	  // Node.js or CommonJS
	  {
	    module.exports = exports = SVGInjector;
	  }
	  /* global -module, -exports, -define */

	}(window, document));
	});

	/**
	 * Export.
	 */

	var toNoCase_1 = toNoCase;

	/**
	 * Test whether a string is camel-case.
	 */

	var hasSpace = /\s/;
	var hasSeparator = /(_|-|\.|:)/;
	var hasCamel = /([a-z][A-Z]|[A-Z][a-z])/;

	/**
	 * Remove any starting case from a `string`, like camel or snake, but keep
	 * spaces and punctuation that may be important otherwise.
	 *
	 * @param {String} string
	 * @return {String}
	 */

	function toNoCase(string) {
	  if (hasSpace.test(string)) return string.toLowerCase()
	  if (hasSeparator.test(string)) return (unseparate(string) || string).toLowerCase()
	  if (hasCamel.test(string)) return uncamelize(string).toLowerCase()
	  return string.toLowerCase()
	}

	/**
	 * Separator splitter.
	 */

	var separatorSplitter = /[\W_]+(.|$)/g;

	/**
	 * Un-separate a `string`.
	 *
	 * @param {String} string
	 * @return {String}
	 */

	function unseparate(string) {
	  return string.replace(separatorSplitter, function (m, next) {
	    return next ? ' ' + next : ''
	  })
	}

	/**
	 * Camelcase splitter.
	 */

	var camelSplitter = /(.)([A-Z]+)/g;

	/**
	 * Un-camelcase a `string`.
	 *
	 * @param {String} string
	 * @return {String}
	 */

	function uncamelize(string) {
	  return string.replace(camelSplitter, function (m, previous, uppers) {
	    return previous + ' ' + uppers.toLowerCase().split('').join(' ')
	  })
	}

	/**
	 * Export.
	 */

	var toSpaceCase_1 = toSpaceCase;

	/**
	 * Convert a `string` to space case.
	 *
	 * @param {String} string
	 * @return {String}
	 */

	function toSpaceCase(string) {
	  return toNoCase_1(string).replace(/[\W_]+(.|$)/g, function (matches, match) {
	    return match ? ' ' + match : ''
	  }).trim()
	}

	/**
	 * Export.
	 */

	var toSlugCase_1 = toSlugCase;

	/**
	 * Convert a `string` to slug case.
	 *
	 * @param {String} string
	 * @return {String}
	 */

	function toSlugCase(string) {
	  return toSpaceCase_1(string).replace(/\s/g, '-')
	}

	var __assign = (undefined && undefined.__assign) || Object.assign || function(t) {
	    for (var s, i = 1, n = arguments.length; i < n; i++) {
	        s = arguments[i];
	        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
	            t[p] = s[p];
	    }
	    return t;
	};
	var colors = {
	    cinnamon600: '#a31b12',
	    cinnamon500: '#de2e21',
	    cinnamon400: '#ff5347',
	    cinnamon300: '#ff867d',
	    cinnamon200: '#fcc9c5',
	    cinnamon100: '#ffefee',
	    peach600: '#b53413',
	    peach500: '#de4721',
	    peach400: '#ff643d',
	    peach300: '#ff957a',
	    peach200: '#ffc2b3',
	    peach100: '#fff3f0',
	    chiliMango600: '#a33600',
	    chiliMango500: '#e04b00',
	    chiliMango400: '#ff671b',
	    chiliMango300: '#ff9b69',
	    chiliMango200: '#ffc7ab',
	    chiliMango100: '#ffe6d9',
	    cantaloupe600: '#c06c00',
	    cantaloupe500: '#f38b00',
	    cantaloupe400: '#ffa126',
	    cantaloupe300: '#ffbc63',
	    cantaloupe200: '#fcd49f',
	    cantaloupe100: '#ffeed9',
	    sourLemon600: '#bd9100',
	    sourLemon500: '#ebb400',
	    sourLemon400: '#f7c72a',
	    sourLemon300: '#ffda61',
	    sourLemon200: '#ffecab',
	    sourLemon100: '#fff9e6',
	    juicyPear600: '#687818',
	    juicyPear500: '#8ea618',
	    juicyPear400: '#a8c224',
	    juicyPear300: '#c4de40',
	    juicyPear200: '#e2f391',
	    juicyPear100: '#f7fae6',
	    kiwi600: '#537824',
	    kiwi500: '#609915',
	    kiwi400: '#77bc1f',
	    kiwi300: '#a7e05c',
	    kiwi200: '#caf593',
	    kiwi100: '#ecfcd7',
	    greenApple600: '#217a37',
	    greenApple500: '#319c4c',
	    greenApple400: '#43c463',
	    greenApple300: '#5fe380',
	    greenApple200: '#acf5be',
	    greenApple100: '#ebfff0',
	    watermelon600: '#00573e',
	    watermelon500: '#0c7a5b',
	    watermelon400: '#12a67c',
	    watermelon300: '#65ccaf',
	    watermelon200: '#b7edde',
	    watermelon100: '#ebfdf8',
	    jewel600: '#156973',
	    jewel500: '#1a818c',
	    jewel400: '#1ea4b3',
	    jewel300: '#44c8d7',
	    jewel200: '#acecf3',
	    jewel100: '#ebfdff',
	    toothpaste600: '#005b82',
	    toothpaste500: '#0271a1',
	    toothpaste400: '#1894c9',
	    toothpaste300: '#40b4e5',
	    toothpaste200: '#99e0ff',
	    toothpaste100: '#d7f1fc',
	    blueberry600: '#004387',
	    blueberry500: '#005cb9',
	    blueberry400: '#0875e1',
	    blueberry300: '#40a0ff',
	    blueberry200: '#a6d2ff',
	    blueberry100: '#d7eafc',
	    plum600: '#264a7a',
	    plum500: '#3166ab',
	    plum400: '#3881e1',
	    plum300: '#529bfa',
	    plum200: '#a6cdff',
	    plum100: '#e6f1ff',
	    berrySmoothie600: '#3b4987',
	    berrySmoothie500: '#4b5eb3',
	    berrySmoothie400: '#5e77e6',
	    berrySmoothie300: '#7891ff',
	    berrySmoothie200: '#c3c2ff',
	    berrySmoothie100: '#e8edff',
	    blackberry600: '#2e2d91',
	    blackberry500: '#413fcc',
	    blackberry400: '#5c59e6',
	    blackberry300: '#8483e6',
	    blackberry200: '#c3c2ff',
	    blackberry100: '#f0f0ff',
	    islandPunch600: '#503882',
	    islandPunch500: '#6345a1',
	    islandPunch400: '#8660d1',
	    islandPunch300: '#a88ae6',
	    islandPunch200: '#d2befa',
	    islandPunch100: '#f5f0ff',
	    grapeSoda600: '#7c3882',
	    grapeSoda500: '#97499e',
	    grapeSoda400: '#c860d1',
	    grapeSoda300: '#de8ae6',
	    grapeSoda200: '#fac0ff',
	    grapeSoda100: '#feebff',
	    pomegranate600: '#99003a',
	    pomegranate500: '#c70550',
	    pomegranate400: '#f31167',
	    pomegranate300: '#ff5c9a',
	    pomegranate200: '#ffbdd6',
	    pomegranate100: '#ffebf3',
	    fruitPunch600: '#b82828',
	    fruitPunch500: '#e12f2f',
	    fruitPunch400: '#ff4c4c',
	    fruitPunch300: '#ff7e7e',
	    fruitPunch200: '#ffbdbd',
	    fruitPunch100: '#ffeeee',
	    rootBeer600: '#664d42',
	    rootBeer500: '#8c7266',
	    rootBeer400: '#ba9a8c',
	    rootBeer300: '#dcbbad',
	    rootBeer200: '#ebd7cf',
	    rootBeer100: '#faf3f0',
	    toastedMarshmallow600: '#8c6000',
	    toastedMarshmallow500: '#b37f10',
	    toastedMarshmallow400: '#cc9e3b',
	    toastedMarshmallow300: '#e6bf6c',
	    toastedMarshmallow200: '#ebd6a9',
	    toastedMarshmallow100: '#fdf6e6',
	    coconut600: '#8f8687',
	    coconut500: '#9e9595',
	    coconut400: '#b3acac',
	    coconut300: '#d1cbcc',
	    coconut200: '#e3dfdf',
	    coconut100: '#f0eeee',
	    cappuccino600: '#231f20',
	    cappuccino500: '#352f2f',
	    cappuccino400: '#4a4242',
	    cappuccino300: '#5e5757',
	    cappuccino200: '#706869',
	    cappuccino100: '#7a7374',
	    soap600: '#b9c0c7',
	    soap500: '#ced3d9',
	    soap400: '#dfe2e6',
	    soap300: '#e8ebed',
	    soap200: '#f0f1f2',
	    soap100: '#f6f7f8',
	    licorice600: '#1f262e',
	    licorice500: '#333d47',
	    licorice400: '#4a5561',
	    licorice300: '#5e6a75',
	    licorice200: '#7b858f',
	    licorice100: '#a1aab3',
	    frenchVanilla600: '#8f8f8f',
	    frenchVanilla500: '#a6a6a6',
	    frenchVanilla400: '#bdbdbd',
	    frenchVanilla300: '#d4d4d4',
	    frenchVanilla200: '#ebebeb',
	    frenchVanilla100: '#ffffff',
	    blackPepper600: '#000000',
	    blackPepper500: '#1e1e1e',
	    blackPepper400: '#333333',
	    blackPepper300: '#494949',
	    blackPepper200: '#616161',
	    blackPepper100: '#787878',
	};
	var gradients = {
	    cinnamon: "linear-gradient(to bottom right," + colors.cinnamon500 + "," + colors.cinnamon400 + ")",
	    peach: "linear-gradient(to bottom right," + colors.peach500 + "," + colors.peach400 + ")",
	    chiliMango: "linear-gradient(to bottom right," + colors.chiliMango500 + "," + colors.chiliMango400 + ")",
	    cantaloupe: "linear-gradient(to bottom right," + colors.cantaloupe500 + "," + colors.cantaloupe400 + ")",
	    sourLemon: "linear-gradient(to bottom right," + colors.sourLemon500 + "," + colors.sourLemon400 + ")",
	    juicyPear: "linear-gradient(to bottom right," + colors.juicyPear500 + "," + colors.juicyPear400 + ")",
	    kiwi: "linear-gradient(to bottom right," + colors.kiwi500 + "," + colors.kiwi400 + ")",
	    greenApple: "linear-gradient(to bottom right," + colors.greenApple500 + "," + colors.greenApple400 + ")",
	    watermelon: "linear-gradient(to bottom right," + colors.watermelon500 + "," + colors.watermelon400 + ")",
	    jewel: "linear-gradient(to bottom right," + colors.jewel500 + "," + colors.jewel400 + ")",
	    toothpaste: "linear-gradient(to bottom right," + colors.toothpaste500 + "," + colors.toothpaste400 + ")",
	    blueberry: "linear-gradient(to bottom right," + colors.blueberry400 + "," + colors.blueberry500 + ")",
	    plum: "linear-gradient(to bottom right," + colors.plum500 + "," + colors.plum400 + ")",
	    berrySmoothie: "linear-gradient(to bottom right," + colors.berrySmoothie500 + "," + colors.berrySmoothie400 + ")",
	    blackberry: "linear-gradient(to bottom right," + colors.blackberry500 + "," + colors.blackberry400 + ")",
	    islandPunch: "linear-gradient(to bottom right," + colors.islandPunch500 + "," + colors.islandPunch400 + ")",
	    grapeSoda: "linear-gradient(to bottom right," + colors.grapeSoda500 + "," + colors.grapeSoda400 + ")",
	    pomegranate: "linear-gradient(to bottom right," + colors.pomegranate500 + "," + colors.pomegranate400 + ")",
	    fruitPunch: "linear-gradient(to bottom right," + colors.fruitPunch500 + "," + colors.fruitPunch400 + ")",
	    rootBeer: "linear-gradient(to bottom right," + colors.rootBeer600 + "," + colors.rootBeer500 + ")",
	    toastedMarshmallow: "linear-gradient(to bottom right," + colors.toastedMarshmallow500 + "," + colors.toastedMarshmallow400 + ")",
	    cappuccino: "linear-gradient(to bottom right," + colors.cappuccino400 + "," + colors.cappuccino300 + ")",
	    licorice: "linear-gradient(to bottom right," + colors.licorice500 + "," + colors.licorice400 + ")",
	    blackPepper: "linear-gradient(to bottom right," + colors.blackPepper400 + "," + colors.blackPepper300 + ")",
	};
	var primary = {
	    background: colors.soap100,
	    headers: colors.blackPepper100,
	    dataViz: colors.blackPepper100,
	    label: colors.blackPepper100,
	    body: colors.blackPepper400,
	    bodySecondary: colors.licorice100,
	    hint: colors.licorice100,
	    iconStandard: colors.licorice200,
	    iconDisabled: colors.soap200,
	    iconHover: colors.licorice500,
	    button: colors.soap200,
	    buttonText: colors.blackPepper100,
	    selectHighlight: colors.blueberry200,
	    link: colors.blueberry400,
	    green: colors.greenApple500,
	    orange: colors.cantaloupe500,
	    red: colors.peach500,
	    active: colors.blueberry500,
	    success: colors.greenApple400,
	    warning: colors.cantaloupe400,
	    error: colors.cinnamon500,
	};
	var canvasColors = __assign({}, colors, { gradients: gradients,
	    primary: primary });

	function getBrandingColors(colors) {
	  const brandingColors = Object.keys(colors.gradients).map(c => `${c}500`);

	  return Object.entries(colors)
	    .filter(([colorName]) => brandingColors.includes(colorName))
	    .reduce((result, [name, value]) => {
	      const obj = {};
	      obj[name.replace('500', '')] = value;
	      return Object.assign({}, result, obj);
	    }, {});
	}

	const brandingColors = getBrandingColors(canvasColors);

	function getHue(color) {
	  const hue = Object.entries(canvasColors).filter(
	    ([colorName]) => color === colorName.replace(/[0-9]*$/, '')
	  );

	  if (hue.length > 0) {
	    return hue.reduce((result, [name, value]) => {
	      const obj = {};
	      obj[name.replace(/^[a-zA-Z]*/g, '')] = value;
	      return Object.assign({}, result, obj);
	    });
	  }

	  return null;
	}

	function getColor(color) {
	  if (color === 'transparent' || color === null) return color;

	  let findColor = color;

	  if (!/[0-9]{3}$/.test(color)) {
	    findColor = `${color}500`;
	  }

	  const foundColor = Object.entries(canvasColors).find(([colorName]) => colorName === findColor);

	  if (!foundColor) return null;

	  return foundColor[1];
	}

	function appendStyle(css) {
	  const style = document.createElement('style');

	  if (style.styleSheet) {
	    // Required for IE8 and below
	    style.styleSheet.cssText = css;
	  } else {
	    style.appendChild(document.createTextNode(css));
	  }

	  document.getElementsByTagName('head')[0].appendChild(style);
	}

	const cdnUrl = 'https://design.workdaycdn.com/beta/assets/web-icons';

	const colorableKeys = {
	  fill: 'data-fill-color',
	  accent: 'data-accent-color',
	  background: 'data-background-color',
	  color: 'data-color',
	  hover: 'data-hover-color',
	  hoverFill: 'data-hover-fill-color',
	  hoverAccent: 'data-hover-accent-color',
	  hoverBackground: 'data-hover-background-color',
	};

	function getColorableFn(classNames, defaultColor = null) {
	  return attrVal =>
	    classNames.reduce((colors, className) => {
	      if (attrVal) {
	        // Assume valid color value if not in palette
	        colors[className] = getColor(attrVal) || attrVal;
	      } else if (defaultColor !== null) {
	        colors[className] = defaultColor;
	      }

	      return colors;
	    }, {});
	}

	const categories = {
	  system: {
	    path: 'system',
	    version: '0.11.16', // TODO: Update to use 'latest' when available
	    prefix: 'wd-icon',
	    colorables: {
	      [colorableKeys.color]: getColorableFn(
	        ['.wd-icon-fill', '.wd-icon-accent'],
	        canvasColors.primary.iconStandard
	      ),
	      [colorableKeys.fill]: getColorableFn(['.wd-icon-fill']),
	      [colorableKeys.accent]: getColorableFn(['.wd-icon-accent']),
	      [colorableKeys.background]: getColorableFn(['.wd-icon-background'], 'transparent'),
	    },
	  },
	  accent: {
	    path: 'accent',
	    version: '0.11.13', // TODO: Update to use 'latest' when available
	    prefix: 'wd-accent',
	    colorables: {
	      [colorableKeys.color]: getColorableFn(['.color-500'], canvasColors.blueberry500),
	    },
	  },
	  applet: {
	    path: 'applet',
	    version: '0.12.0', // TODO: Update to use 'latest' when available
	    prefix: 'wd-applet',
	    colorables: {
	      [colorableKeys.color]: attrVal => {
	        const hue = getHue(attrVal) || getHue('blueberry');

	        if (!hue) {
	          throw new Error(`"${attrVal}" is not a valid applet color.`);
	        }

	        return {
	          '.color-100': canvasColors.frenchVanilla100,
	          '.color-200': hue[200],
	          '.color-300': hue[300],
	          '.color-400': hue[400],
	          '.color-400-alpha-20': hue[400],
	          '.color-500': hue[500],
	        };
	      },
	    },
	  },
	};

	function getIconCategory(elem) {
	  return categories[elem.getAttribute('data-category')];
	}

	function getIcon(icon, category, iconsPath = null) {
	  const categoryConfig = categories[category];
	  const iconFileName = `${categoryConfig.prefix}-${toSlugCase_1(icon)}.svg`;

	  if (iconsPath) {
	    return `${iconsPath}/${categoryConfig.path}/${iconFileName}`;
	  }

	  return `${cdnUrl}/${categoryConfig.path}@${categoryConfig.version}/svg/${iconFileName}`;
	}

	function colorIconClass(icon, className, fillColor) {
	  icon.querySelectorAll(className).forEach(f => {
	    f.setAttribute('fill', fillColor); // eslint-disable-line no-param-reassign
	  });
	}

	function colorIconHoverClasses(iconSelector, classNames, fillColor) {
	  if (fillColor) {
	    classNames.forEach(className => {
	      appendStyle(`
        ${iconSelector}:hover ${className} {
          fill: ${getColor(fillColor) || fillColor};
        }
      `);
	    });
	  }
	}

	function colorIcons(selector, iconRoot = document) {
	  const icons = iconRoot.querySelectorAll(selector);

	  icons.forEach(i => {
	    const category = getIconCategory(i);

	    Object.entries(category.colorables).forEach(([attr, className]) => {
	      if (typeof className === 'function') {
	        Object.entries(className(i.getAttribute(attr))).forEach(([cName, color]) => {
	          colorIconClass(i, cName, color);
	        });
	        return;
	      }

	      const fillColor = i.getAttribute(attr);
	      colorIconClass(i, className, fillColor);
	    });
	  });
	}

	function sizeIcons(selector, iconRoot = document) {
	  const icons = iconRoot.querySelectorAll(selector);

	  icons.forEach(i => {
	    const size = i.getAttribute('data-size');
	    if (size) {
	      i.style.height = `${size}px`;
	      i.style.width = `${size}px`;
	    }
	  });
	}

	function styleAccentIcons(selector, iconRoot = document) {
	  // Style transparent accent icons
	  const selectorFragment = '[data-category="accent"][data-transparent]';
	  const transparentSelector = `${selector}${selectorFragment}`;
	  const transparentIcons = iconRoot.querySelectorAll(transparentSelector);

	  transparentIcons.forEach(i => {
	    i.querySelector('.french-vanilla-100').style.fill = 'transparent';
	  });
	}

	function styleSystemIcons(selector, iconRoot = document) {
	  styleSystemIconCircles(selector, iconRoot);
	  styleSystemIconHovers(selector, iconRoot);
	}

	function styleSystemIconCircles(selector, iconRoot = document) {
	  const selectorFragment = '[data-category="system"][data-circle-background]';
	  const circleSelector = `${selector}${selectorFragment}`;
	  const iconCircles = iconRoot.querySelectorAll(circleSelector);

	  iconCircles.forEach(i => {
	    const circle = iconRoot.createElement('div');
	    circle.setAttribute('class', 'wdc-icon-circle-container');

	    const size = i.getAttribute('data-size') || 40;
	    circle.style.height = `${size}px`;
	    circle.style.width = `${size}px`;
	    i.style.height = `${size * 0.625}px`;
	    i.style.width = `${size * 0.625}px`;

	    let circleBgColor = i.getAttribute('data-circle-background');
	    circleBgColor = circleBgColor === 'true' ? 'soap300' : circleBgColor;
	    circleBgColor = getColor(circleBgColor) || circleBgColor;
	    circle.style.backgroundColor = circleBgColor;

	    const iconColor = canvasKitReactCommon.pickForegroundColor(circleBgColor, 'rgba(0,0,0,0.65)');
	    i.setAttribute(colorableKeys.fill, iconColor);
	    i.setAttribute(colorableKeys.accent, iconColor);

	    circle.innerHTML = i.outerHTML;
	    i.parentNode.replaceChild(circle, i);
	  });
	}

	function styleSystemIconHovers(selector, iconRoot = document) {
	  const selectorFragment = '[data-category="system"]:not([data-circle-background])';
	  const hoverableSelector = `${selector}${selectorFragment}`;

	  // Style default hovers
	  colorIconHoverClasses(hoverableSelector, ['.wd-icon-background'], 'transparent');
	  colorIconHoverClasses(
	    hoverableSelector,
	    ['.wd-icon-accent', '.wd-icon-fill'],
	    canvasColors.primary.iconHover
	  );

	  // Style individual hovers
	  const hoverableSystemIcons = iconRoot.querySelectorAll(hoverableSelector);

	  hoverableSystemIcons.forEach((i, index) => {
	    const iconClassName = `hoverable-system-icon-${index}`;
	    const iconSelector = `.${iconClassName}${selectorFragment}`;

	    i.classList.add(iconClassName);

	    colorIconHoverClasses(
	      iconSelector,
	      ['.wd-icon-accent', '.wd-icon-fill'],
	      i.getAttribute(colorableKeys.hover)
	    );
	    colorIconHoverClasses(iconSelector, ['.wd-icon-fill'], i.getAttribute(colorableKeys.hoverFill));
	    colorIconHoverClasses(
	      iconSelector,
	      ['.wd-icon-accent'],
	      i.getAttribute(colorableKeys.hoverAccent)
	    );
	    colorIconHoverClasses(
	      iconSelector,
	      ['.wd-icon-background'],
	      i.getAttribute(colorableKeys.hoverBackground)
	    );
	  });
	}

	function injectIcons(iconsPath = null, selector = '.wdc-icon', iconRoot = document) {
	  const icons = iconRoot.querySelectorAll(selector);

	  // Add data source
	  icons.forEach(i => {
	    const icon = getIcon(i.getAttribute('data-icon'), i.getAttribute('data-category'), iconsPath);

	    i.setAttribute('data-src', icon);
	  });

	  svgInjector(icons, {}, () => {
	    sizeIcons(selector, iconRoot);

	    styleAccentIcons(selector, iconRoot);
	    styleSystemIcons(selector, iconRoot);

	    // colorIcons must be called at the end of this block (since previous calls
	    // in this block may have adjusted coloring)
	    colorIcons(selector, iconRoot);
	  });
	}

	return injectIcons;

}));
//# sourceMappingURL=canvas-kit-css-icon.js.map
