import * as React from 'react';
import { ErrorType } from '@workday/canvas-kit-react-common';
import { Themeable } from '@workday/canvas-kit-labs-react-core';
export declare enum BannerVariant {
    Full = 0,
    Sticky = 1
}
export interface BannerProps extends Themeable, React.ButtonHTMLAttributes<HTMLButtonElement> {
    onClick?: (e: React.SyntheticEvent) => void;
    label?: React.ReactNode;
    variant?: BannerVariant;
    error?: ErrorType;
    actionText?: string;
}
export default class Banner extends React.Component<BannerProps> {
    static Variant: typeof BannerVariant;
    static ErrorType: typeof ErrorType;
    static defaultProps: {
        actionText: string;
        error: ErrorType;
        variant: BannerVariant;
    };
    render(): JSX.Element;
}
