"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
var canvas_kit_react_icon_1 = require("@workday/canvas-kit-react-icon");
var canvas_system_icons_web_1 = require("@workday/canvas-system-icons-web");
var canvas_kit_react_common_1 = require("@workday/canvas-kit-react-common");
var canvas_kit_labs_react_core_1 = require("@workday/canvas-kit-labs-react-core");
var BannerVariant;
(function (BannerVariant) {
    BannerVariant[BannerVariant["Full"] = 0] = "Full";
    BannerVariant[BannerVariant["Sticky"] = 1] = "Sticky";
})(BannerVariant = exports.BannerVariant || (exports.BannerVariant = {}));
var BannerWrapper = canvas_kit_labs_react_core_1.styled('button')(__assign({}, canvas_kit_react_core_1.type.body2, { backgroundColor: canvas_kit_react_core_1.colors.cantaloupe400, boxSizing: 'border-box', color: canvas_kit_react_core_1.colors.blackPepper400, fontSize: 14, fontWeight: 500, padding: canvas_kit_react_core_1.spacing.xxs + " " + canvas_kit_react_core_1.spacing.s, textAlign: 'left', border: 0, display: 'flex', alignItems: 'center', transition: 'background-color 120ms', '&:focus': __assign({ outline: 'none' }, canvas_kit_react_common_1.focusRing(2, 2)), '&:hover': {
        cursor: 'pointer',
    } }), function (_a) {
    var error = _a.error, variant = _a.variant;
    return ({
        backgroundColor: error === canvas_kit_react_common_1.ErrorType.Error ? canvas_kit_react_core_1.colors.cinnamon500 : canvas_kit_react_core_1.colors.cantaloupe400,
        color: error === canvas_kit_react_common_1.ErrorType.Error ? canvas_kit_react_core_1.colors.frenchVanilla100 : canvas_kit_react_core_1.colors.blackPepper400,
        borderRadius: variant === BannerVariant.Sticky ? canvas_kit_react_core_1.borderRadius.m + " 0 0 " + canvas_kit_react_core_1.borderRadius.m : canvas_kit_react_core_1.borderRadius.m,
        width: variant === BannerVariant.Sticky ? '222px' : '328px',
        '&:hover': {
            backgroundColor: error === canvas_kit_react_common_1.ErrorType.Error ? canvas_kit_react_core_1.colors.cinnamon600 : canvas_kit_react_core_1.colors.cantaloupe500,
        },
    });
});
var BannerIcon = canvas_kit_labs_react_core_1.styled(canvas_kit_react_icon_1.SystemIcon)({
    marginRight: canvas_kit_react_core_1.spacing.xs,
});
var BannerLabel = canvas_kit_labs_react_core_1.styled('div')({
    flex: 1,
});
var BannerViewAll = canvas_kit_labs_react_core_1.styled('span')({
    textDecoration: 'underline',
}, function (_a) {
    var variant = _a.variant;
    return ({
        display: variant === BannerVariant.Sticky ? 'none' : undefined,
    });
});
var Banner = (function (_super) {
    __extends(Banner, _super);
    function Banner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Banner.prototype.render = function () {
        var _a = this.props, label = _a.label, onClick = _a.onClick, actionText = _a.actionText, variant = _a.variant, error = _a.error, props = __rest(_a, ["label", "onClick", "actionText", "variant", "error"]);
        var bannerIcon = error === canvas_kit_react_common_1.ErrorType.Error ? canvas_system_icons_web_1.exclamationCircleIcon : canvas_system_icons_web_1.exclamationTriangleIcon;
        var iconColor = error === canvas_kit_react_common_1.ErrorType.Error ? canvas_kit_react_core_1.colors.frenchVanilla100 : canvas_kit_react_core_1.colors.blackPepper400;
        var iconSize = 24;
        return (React.createElement(BannerWrapper, __assign({ "aria-label": actionText + ': ' + label, role: "button", variant: variant, tabIndex: 0, onClick: onClick, error: error }, props),
            React.createElement(BannerIcon, { icon: bannerIcon, color: iconColor, colorHover: iconColor, size: iconSize }),
            React.createElement(BannerLabel, null, label),
            React.createElement(BannerViewAll, { variant: variant }, actionText)));
    };
    Banner.Variant = BannerVariant;
    Banner.ErrorType = canvas_kit_react_common_1.ErrorType;
    Banner.defaultProps = {
        actionText: 'View All',
        error: canvas_kit_react_common_1.ErrorType.Alert,
        variant: BannerVariant.Full,
    };
    return Banner;
}(React.Component));
exports.default = Banner;
