var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { colors, spacing, borderRadius, type } from '@workday/canvas-kit-react-core';
import { SystemIcon } from '@workday/canvas-kit-react-icon';
import { exclamationCircleIcon, exclamationTriangleIcon } from '@workday/canvas-system-icons-web';
import { ErrorType, focusRing } from '@workday/canvas-kit-react-common';
import { styled } from '@workday/canvas-kit-labs-react-core';
export var BannerVariant;
(function (BannerVariant) {
    BannerVariant[BannerVariant["Full"] = 0] = "Full";
    BannerVariant[BannerVariant["Sticky"] = 1] = "Sticky";
})(BannerVariant || (BannerVariant = {}));
var BannerWrapper = styled('button')(__assign({}, type.body2, { backgroundColor: colors.cantaloupe400, boxSizing: 'border-box', color: colors.blackPepper400, fontSize: 14, fontWeight: 500, padding: spacing.xxs + " " + spacing.s, textAlign: 'left', border: 0, display: 'flex', alignItems: 'center', transition: 'background-color 120ms', '&:focus': __assign({ outline: 'none' }, focusRing(2, 2)), '&:hover': {
        cursor: 'pointer',
    } }), function (_a) {
    var error = _a.error, variant = _a.variant;
    return ({
        backgroundColor: error === ErrorType.Error ? colors.cinnamon500 : colors.cantaloupe400,
        color: error === ErrorType.Error ? colors.frenchVanilla100 : colors.blackPepper400,
        borderRadius: variant === BannerVariant.Sticky ? borderRadius.m + " 0 0 " + borderRadius.m : borderRadius.m,
        width: variant === BannerVariant.Sticky ? '222px' : '328px',
        '&:hover': {
            backgroundColor: error === ErrorType.Error ? colors.cinnamon600 : colors.cantaloupe500,
        },
    });
});
var BannerIcon = styled(SystemIcon)({
    marginRight: spacing.xs,
});
var BannerLabel = styled('div')({
    flex: 1,
});
var BannerViewAll = styled('span')({
    textDecoration: 'underline',
}, function (_a) {
    var variant = _a.variant;
    return ({
        display: variant === BannerVariant.Sticky ? 'none' : undefined,
    });
});
var Banner = (function (_super) {
    __extends(Banner, _super);
    function Banner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Banner.prototype.render = function () {
        var _a = this.props, label = _a.label, onClick = _a.onClick, actionText = _a.actionText, variant = _a.variant, error = _a.error, props = __rest(_a, ["label", "onClick", "actionText", "variant", "error"]);
        var bannerIcon = error === ErrorType.Error ? exclamationCircleIcon : exclamationTriangleIcon;
        var iconColor = error === ErrorType.Error ? colors.frenchVanilla100 : colors.blackPepper400;
        var iconSize = 24;
        return (React.createElement(BannerWrapper, __assign({ "aria-label": actionText + ': ' + label, role: "button", variant: variant, tabIndex: 0, onClick: onClick, error: error }, props),
            React.createElement(BannerIcon, { icon: bannerIcon, color: iconColor, colorHover: iconColor, size: iconSize }),
            React.createElement(BannerLabel, null, label),
            React.createElement(BannerViewAll, { variant: variant }, actionText)));
    };
    Banner.Variant = BannerVariant;
    Banner.ErrorType = ErrorType;
    Banner.defaultProps = {
        actionText: 'View All',
        error: ErrorType.Alert,
        variant: BannerVariant.Full,
    };
    return Banner;
}(React.Component));
export default Banner;
