import * as React from 'react';
import { CanvasDepthValue, CanvasSpacingValue } from '@workday/canvas-kit-react-core';
export interface CardProps extends React.HTMLAttributes<HTMLDivElement> {
    heading?: React.ReactNode;
    headingId?: string;
    padding: CanvasSpacingValue;
    depth: CanvasDepthValue;
    width?: number | string;
    height?: number | string;
}
export default class Card extends React.Component<CardProps> {
    static defaultProps: {
        depth: {
            boxShadow: "0px 4px 8px 0 rgba(0, 0, 0, 0.1)";
        };
        padding: CanvasSpacingValue;
    };
    render(): JSX.Element;
}
