"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var styled_1 = __importDefault(require("@emotion/styled"));
var canvas_kit_react_common_1 = require("@workday/canvas-kit-react-common");
var canvas_kit_react_core_1 = __importStar(require("@workday/canvas-kit-react-core"));
var canvas_kit_react_icon_1 = require("@workday/canvas-kit-react-icon");
var canvas_system_icons_web_1 = require("@workday/canvas-system-icons-web");
var v4_1 = __importDefault(require("uuid/v4"));
var checkboxHeight = 18;
var checkboxTapArea = canvas_kit_react_core_1.spacingNumbers.m;
var checkboxContainerHeight = checkboxTapArea;
var checkboxLabelDistance = canvas_kit_react_core_1.spacingNumbers.xs;
var checkboxWidth = 18;
var rippleRadius = (canvas_kit_react_core_1.spacingNumbers.l - checkboxWidth) / 2;
var CheckboxContainer = styled_1.default('div')({
    display: 'flex',
    alignItems: 'center',
    minHeight: checkboxContainerHeight,
    position: 'relative',
});
var CheckboxInputWrapper = styled_1.default('div')({
    height: checkboxHeight,
    width: checkboxWidth,
    marginTop: '3px',
    alignSelf: 'flex-start',
    '&::after': {
        borderRadius: canvas_kit_react_core_1.borderRadius.circle,
        boxShadow: '0 0 0 0 ' + canvas_kit_react_core_1.colors.soap200,
        content: '""',
        display: 'inline-block',
        height: checkboxHeight,
        transition: 'box-shadow 150ms ease-out',
        width: checkboxWidth,
        zIndex: 1,
    },
}, function (_a) {
    var disabled = _a.disabled;
    return ({
        '&:hover::after': {
            boxShadow: disabled ? undefined : '0 0 0 ' + rippleRadius + 'px ' + canvas_kit_react_core_1.colors.soap200,
        },
    });
});
var CheckboxInput = styled_1.default('input')(__assign({ borderRadius: canvas_kit_react_core_1.borderRadius.s, width: checkboxTapArea, height: checkboxTapArea, margin: 0, marginTop: '-3px', marginLeft: '-3px', position: 'absolute', opacity: 0, '&:not(:disabled)': {
        cursor: 'pointer',
    }, '&:not(:checked):not(:disabled):not(:focus):hover ~ div:first-of-type': {
        borderColor: canvas_kit_react_core_1.inputColors.hoverBorder,
    }, '&:checked ~ div:first-of-type': {
        borderColor: canvas_kit_react_core_1.colors.blueberry400,
        backgroundColor: canvas_kit_react_core_1.colors.blueberry400,
    }, '&:disabled ~ div:first-of-type': {
        borderColor: canvas_kit_react_core_1.inputColors.disabled.border,
        backgroundColor: canvas_kit_react_core_1.inputColors.disabled.background,
    }, '&:disabled:checked ~ div:first-of-type': {
        borderColor: canvas_kit_react_core_1.colors.blueberry200,
        backgroundColor: canvas_kit_react_core_1.colors.blueberry200,
    }, '&:focus, &:active': {
        outline: 'none',
    }, '&:focus ~ div:first-of-type': {
        borderColor: canvas_kit_react_core_1.colors.blueberry400,
        borderWidth: '2px',
        zIndex: 2,
        boxShadow: 'none',
    }, '&:checked:focus ~ div:first-of-type': __assign({}, canvas_kit_react_common_1.focusRing(2, 2, false), { '& span': {
            marginLeft: '-7px',
        } }) }, canvas_kit_react_common_1.mouseFocusBehavior({
    '&:focus ~ div:first-of-type': {
        border: "1px solid " + canvas_kit_react_core_1.inputColors.border,
        boxShadow: 'none',
        '& span': {
            marginLeft: '-6px',
        },
    },
    '&:checked ~ div:first-of-type': {
        borderColor: canvas_kit_react_core_1.colors.blueberry400,
    },
    '&:disabled:checked ~ div:first-of-type': {
        borderColor: canvas_kit_react_core_1.colors.blueberry200,
        backgroundColor: canvas_kit_react_core_1.colors.blueberry200,
    },
})), function (_a) {
    var error = _a.error;
    var errorRingColor;
    var errorRingBorderColor = 'transparent';
    if (error === canvas_kit_react_common_1.ErrorType.Error) {
        errorRingColor = canvas_kit_react_core_1.inputColors.error.border;
    }
    else if (error === canvas_kit_react_common_1.ErrorType.Alert) {
        errorRingColor = canvas_kit_react_core_1.inputColors.warning.border;
        errorRingBorderColor = canvas_kit_react_core_1.colors.cantaloupe600;
    }
    else {
        return;
    }
    var errorStyles = {
        '& ~ div:first-of-type': {
            border: "1px solid " + errorRingColor,
            boxShadow: "0 0 0 1px " + errorRingColor + ", 0 0 0 2px " + errorRingBorderColor,
        },
        '&:not(:checked):not(:disabled):not(:focus):hover ~ div:first-of-type': {
            borderColor: errorRingColor,
        },
        '&:checked ~ div:first-of-type': {
            borderColor: canvas_kit_react_core_1.colors.blueberry400,
            boxShadow: "\n            0 0 0 2px " + canvas_kit_react_core_1.colors.frenchVanilla100 + ",\n            0 0 0 4px " + errorRingColor + ",\n            0 0 0 5px " + errorRingBorderColor,
        },
    };
    return __assign({}, errorStyles, canvas_kit_react_common_1.mouseFocusBehavior(__assign({}, errorStyles, { '&:not(:checked):focus ~ div:first-of-type': {
            border: "1px solid " + errorRingColor,
            boxShadow: "0 0 0 1px " + errorRingColor + ", 0 0 0 2px " + errorRingBorderColor,
        } })));
});
var CheckboxBackground = styled_1.default('div')({
    alignItems: 'center',
    backgroundColor: canvas_kit_react_core_1.colors.frenchVanilla100,
    borderRadius: canvas_kit_react_core_1.borderRadius.s,
    border: '1px solid ' + canvas_kit_react_core_1.inputColors.border,
    boxSizing: 'border-box',
    display: 'flex',
    height: checkboxHeight,
    justifyContent: 'center',
    padding: '0px 2px',
    pointerEvents: 'none',
    position: 'absolute',
    transition: 'border 200ms ease, background 200ms',
    width: checkboxWidth,
});
var CheckboxCheck = styled_1.default('div')({
    display: 'flex',
    flexDirection: 'column',
    maxWidth: '100%',
    pointerEvents: 'none',
    transition: 'transform 200ms ease, opacity 200ms ease',
    span: {
        marginLeft: '-6px',
        transition: 'margin 200ms ease',
    },
}, function (_a) {
    var checked = _a.checked;
    return ({
        opacity: checked ? 1 : 0,
        transform: checked ? 'scale(1)' : 'scale(0.5)',
    });
});
var IndeterminateBox = styled_1.default('div')({
    width: '10px',
    height: '2px',
    backgroundColor: canvas_kit_react_core_1.default.colors.frenchVanilla100,
});
var CheckboxLabel = styled_1.default('label')(__assign({}, canvas_kit_react_core_1.default.type.body, { paddingLeft: checkboxLabelDistance }), function (_a) {
    var disabled = _a.disabled;
    return (disabled ? { color: canvas_kit_react_core_1.inputColors.disabled.text } : { cursor: 'pointer' });
});
var Checkbox = (function (_super) {
    __extends(Checkbox, _super);
    function Checkbox() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = v4_1.default();
        return _this;
    }
    Checkbox.prototype.render = function () {
        var _a = this.props, checked = _a.checked, disabled = _a.disabled, _b = _a.id, id = _b === void 0 ? this.id : _b, inputRef = _a.inputRef, label = _a.label, onChange = _a.onChange, value = _a.value, error = _a.error, indeterminate = _a.indeterminate, elemProps = __rest(_a, ["checked", "disabled", "id", "inputRef", "label", "onChange", "value", "error", "indeterminate"]);
        return (React.createElement(CheckboxContainer, null,
            React.createElement(CheckboxInputWrapper, { disabled: disabled },
                React.createElement(CheckboxInput, __assign({ checked: checked, disabled: disabled, id: id, ref: inputRef, onChange: onChange, type: "checkbox", value: value, error: error }, elemProps)),
                React.createElement(CheckboxBackground, { checked: checked, disabled: disabled },
                    React.createElement(CheckboxCheck, { checked: checked }, indeterminate ? (React.createElement(IndeterminateBox, null)) : (React.createElement(canvas_kit_react_icon_1.SystemIcon, { icon: canvas_system_icons_web_1.checkSmallIcon, color: canvas_kit_react_core_1.iconColors.inverse }))))),
            label && (React.createElement(CheckboxLabel, { htmlFor: id, disabled: disabled }, label))));
    };
    Checkbox.ErrorType = canvas_kit_react_common_1.ErrorType;
    Checkbox.defaultProps = {
        checked: false,
        label: '',
    };
    return Checkbox;
}(React.Component));
exports.default = Checkbox;
