import * as React from 'react';
import { ErrorType } from '@workday/canvas-kit-react-common';
export interface CheckboxProps extends React.InputHTMLAttributes<HTMLInputElement> {
    checked: boolean;
    disabled?: boolean;
    id?: string;
    inputRef?: React.Ref<HTMLInputElement>;
    label?: string;
    onChange?: (e: React.SyntheticEvent) => void;
    value?: string;
    error?: ErrorType;
    indeterminate?: boolean;
}
export default class Checkbox extends React.Component<CheckboxProps> {
    static ErrorType: typeof ErrorType;
    static defaultProps: {
        checked: boolean;
        label: string;
    };
    private id;
    render(): JSX.Element;
}
