var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import styled from '@emotion/styled';
import { ErrorType, focusRing, mouseFocusBehavior } from '@workday/canvas-kit-react-common';
import canvas, { borderRadius, colors, iconColors, inputColors, spacingNumbers as spacing, } from '@workday/canvas-kit-react-core';
import { SystemIcon } from '@workday/canvas-kit-react-icon';
import { checkSmallIcon } from '@workday/canvas-system-icons-web';
import uuid from 'uuid/v4';
var checkboxHeight = 18;
var checkboxTapArea = spacing.m;
var checkboxContainerHeight = checkboxTapArea;
var checkboxLabelDistance = spacing.xs;
var checkboxWidth = 18;
var rippleRadius = (spacing.l - checkboxWidth) / 2;
var CheckboxContainer = styled('div')({
    display: 'flex',
    alignItems: 'center',
    minHeight: checkboxContainerHeight,
    position: 'relative',
});
var CheckboxInputWrapper = styled('div')({
    height: checkboxHeight,
    width: checkboxWidth,
    marginTop: '3px',
    alignSelf: 'flex-start',
    '&::after': {
        borderRadius: borderRadius.circle,
        boxShadow: '0 0 0 0 ' + colors.soap200,
        content: '""',
        display: 'inline-block',
        height: checkboxHeight,
        transition: 'box-shadow 150ms ease-out',
        width: checkboxWidth,
        zIndex: 1,
    },
}, function (_a) {
    var disabled = _a.disabled;
    return ({
        '&:hover::after': {
            boxShadow: disabled ? undefined : '0 0 0 ' + rippleRadius + 'px ' + colors.soap200,
        },
    });
});
var CheckboxInput = styled('input')(__assign({ borderRadius: borderRadius.s, width: checkboxTapArea, height: checkboxTapArea, margin: 0, marginTop: '-3px', marginLeft: '-3px', position: 'absolute', opacity: 0, '&:not(:disabled)': {
        cursor: 'pointer',
    }, '&:not(:checked):not(:disabled):not(:focus):hover ~ div:first-of-type': {
        borderColor: inputColors.hoverBorder,
    }, '&:checked ~ div:first-of-type': {
        borderColor: colors.blueberry400,
        backgroundColor: colors.blueberry400,
    }, '&:disabled ~ div:first-of-type': {
        borderColor: inputColors.disabled.border,
        backgroundColor: inputColors.disabled.background,
    }, '&:disabled:checked ~ div:first-of-type': {
        borderColor: colors.blueberry200,
        backgroundColor: colors.blueberry200,
    }, '&:focus, &:active': {
        outline: 'none',
    }, '&:focus ~ div:first-of-type': {
        borderColor: colors.blueberry400,
        borderWidth: '2px',
        zIndex: 2,
        boxShadow: 'none',
    }, '&:checked:focus ~ div:first-of-type': __assign({}, focusRing(2, 2, false), { '& span': {
            marginLeft: '-7px',
        } }) }, mouseFocusBehavior({
    '&:focus ~ div:first-of-type': {
        border: "1px solid " + inputColors.border,
        boxShadow: 'none',
        '& span': {
            marginLeft: '-6px',
        },
    },
    '&:checked ~ div:first-of-type': {
        borderColor: colors.blueberry400,
    },
    '&:disabled:checked ~ div:first-of-type': {
        borderColor: colors.blueberry200,
        backgroundColor: colors.blueberry200,
    },
})), function (_a) {
    var error = _a.error;
    var errorRingColor;
    var errorRingBorderColor = 'transparent';
    if (error === ErrorType.Error) {
        errorRingColor = inputColors.error.border;
    }
    else if (error === ErrorType.Alert) {
        errorRingColor = inputColors.warning.border;
        errorRingBorderColor = colors.cantaloupe600;
    }
    else {
        return;
    }
    var errorStyles = {
        '& ~ div:first-of-type': {
            border: "1px solid " + errorRingColor,
            boxShadow: "0 0 0 1px " + errorRingColor + ", 0 0 0 2px " + errorRingBorderColor,
        },
        '&:not(:checked):not(:disabled):not(:focus):hover ~ div:first-of-type': {
            borderColor: errorRingColor,
        },
        '&:checked ~ div:first-of-type': {
            borderColor: colors.blueberry400,
            boxShadow: "\n            0 0 0 2px " + colors.frenchVanilla100 + ",\n            0 0 0 4px " + errorRingColor + ",\n            0 0 0 5px " + errorRingBorderColor,
        },
    };
    return __assign({}, errorStyles, mouseFocusBehavior(__assign({}, errorStyles, { '&:not(:checked):focus ~ div:first-of-type': {
            border: "1px solid " + errorRingColor,
            boxShadow: "0 0 0 1px " + errorRingColor + ", 0 0 0 2px " + errorRingBorderColor,
        } })));
});
var CheckboxBackground = styled('div')({
    alignItems: 'center',
    backgroundColor: colors.frenchVanilla100,
    borderRadius: borderRadius.s,
    border: '1px solid ' + inputColors.border,
    boxSizing: 'border-box',
    display: 'flex',
    height: checkboxHeight,
    justifyContent: 'center',
    padding: '0px 2px',
    pointerEvents: 'none',
    position: 'absolute',
    transition: 'border 200ms ease, background 200ms',
    width: checkboxWidth,
});
var CheckboxCheck = styled('div')({
    display: 'flex',
    flexDirection: 'column',
    maxWidth: '100%',
    pointerEvents: 'none',
    transition: 'transform 200ms ease, opacity 200ms ease',
    span: {
        marginLeft: '-6px',
        transition: 'margin 200ms ease',
    },
}, function (_a) {
    var checked = _a.checked;
    return ({
        opacity: checked ? 1 : 0,
        transform: checked ? 'scale(1)' : 'scale(0.5)',
    });
});
var IndeterminateBox = styled('div')({
    width: '10px',
    height: '2px',
    backgroundColor: canvas.colors.frenchVanilla100,
});
var CheckboxLabel = styled('label')(__assign({}, canvas.type.body, { paddingLeft: checkboxLabelDistance }), function (_a) {
    var disabled = _a.disabled;
    return (disabled ? { color: inputColors.disabled.text } : { cursor: 'pointer' });
});
var Checkbox = (function (_super) {
    __extends(Checkbox, _super);
    function Checkbox() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = uuid();
        return _this;
    }
    Checkbox.prototype.render = function () {
        var _a = this.props, checked = _a.checked, disabled = _a.disabled, _b = _a.id, id = _b === void 0 ? this.id : _b, inputRef = _a.inputRef, label = _a.label, onChange = _a.onChange, value = _a.value, error = _a.error, indeterminate = _a.indeterminate, elemProps = __rest(_a, ["checked", "disabled", "id", "inputRef", "label", "onChange", "value", "error", "indeterminate"]);
        return (React.createElement(CheckboxContainer, null,
            React.createElement(CheckboxInputWrapper, { disabled: disabled },
                React.createElement(CheckboxInput, __assign({ checked: checked, disabled: disabled, id: id, ref: inputRef, onChange: onChange, type: "checkbox", value: value, error: error }, elemProps)),
                React.createElement(CheckboxBackground, { checked: checked, disabled: disabled },
                    React.createElement(CheckboxCheck, { checked: checked }, indeterminate ? (React.createElement(IndeterminateBox, null)) : (React.createElement(SystemIcon, { icon: checkSmallIcon, color: iconColors.inverse }))))),
            label && (React.createElement(CheckboxLabel, { htmlFor: id, disabled: disabled }, label))));
    };
    Checkbox.ErrorType = ErrorType;
    Checkbox.defaultProps = {
        checked: false,
        label: '',
    };
    return Checkbox;
}(React.Component));
export default Checkbox;
