import * as React from 'react';
import PopperJS from 'popper.js';
export declare type Placement = PopperJS.Placement;
export declare type PopperOptions = PopperJS.PopperOptions;
export interface PopperProps extends React.HTMLAttributes<HTMLDivElement> {
    anchorElement: Element | null;
    children: React.ReactNode;
    containerElement?: Element;
    open: boolean;
    placement: Placement;
    popperOptions?: PopperOptions;
    portal: boolean;
}
export declare class Popper extends React.PureComponent<PopperProps> {
    private popper;
    static defaultProps: {
        open: boolean;
        placement: string;
        portal: boolean;
    };
    componentWillUnmount(): void;
    render(): JSX.Element | null;
    renderPopper(): JSX.Element;
    private openPopper;
}
