"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("../types");
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
function errorRing(error) {
    var errorBorderColor;
    var errorBoxShadow;
    if (error === types_1.ErrorType.Error) {
        errorBorderColor = canvas_kit_react_core_1.inputColors.error.border;
        errorBoxShadow = "inset 0 0 0 1px " + canvas_kit_react_core_1.inputColors.error.border;
    }
    else if (error === types_1.ErrorType.Alert) {
        errorBorderColor = canvas_kit_react_core_1.colors.cantaloupe600;
        errorBoxShadow = "inset 0 0 0 2px " + canvas_kit_react_core_1.inputColors.warning.border;
    }
    else {
        return {};
    }
    return {
        borderColor: errorBorderColor,
        transition: '100ms box-shadow',
        boxShadow: errorBoxShadow,
        '&:hover': {
            borderColor: errorBorderColor,
        },
        '&:focus:not([disabled])': {
            borderColor: errorBorderColor,
            boxShadow: errorBoxShadow + ",\n        0 0 0 2px " + canvas_kit_react_core_1.colors.frenchVanilla100 + ",\n        0 0 0 4px " + canvas_kit_react_core_1.inputColors.focusBorder,
        },
    };
}
exports.default = errorRing;
