"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
var hideMouseFocus = (_a = {},
    _a["[data-whatinput='mouse'] &:focus,\n    [data-whatinput='touch'] &:focus,\n    [data-whatinput='pointer'] &:focus"] = {
        outline: 'none',
        boxShadow: 'none',
        animation: 'none',
    },
    _a);
exports.mouseFocusBehavior = function (selectors) {
    var output = {};
    Object.keys(selectors).map(function (selector, index) {
        selector.split(',').forEach(function (selectorPart) {
            var prefixedSelector = "\n        [data-whatinput=\"mouse\"] " + selectorPart + ",\n        [data-whatinput=\"touch\"] " + selectorPart + ",\n        [data-whatinput=\"pointer\"] " + selectorPart;
            output[prefixedSelector] = selectors[selector];
        });
    });
    return output;
};
exports.default = hideMouseFocus;
