"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
exports.expandHex = function (hex) {
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    return hex.replace(shorthandRegex, function (m, r, g, b) {
        return r + r + g + g + b + b;
    });
};
var hexToRgb = function (hex) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(exports.expandHex(hex));
    return result
        ? {
            r: parseInt(result[1], 16),
            g: parseInt(result[2], 16),
            b: parseInt(result[3], 16),
        }
        : null;
};
exports.pickForegroundColor = function (background, darkColor, lightColor) {
    if (darkColor === void 0) { darkColor = canvas_kit_react_core_1.colors.blackPepper600; }
    if (lightColor === void 0) { lightColor = canvas_kit_react_core_1.colors.frenchVanilla100; }
    var rgbColor = hexToRgb(background);
    if (rgbColor) {
        var r = rgbColor.r;
        var g = rgbColor.g;
        var b = rgbColor.b;
        return r * 0.299 + g * 0.587 + b * 0.114 > 186 ? darkColor : lightColor;
    }
    else {
        return;
    }
};
