var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import PopperJS from 'popper.js';
var Popper = (function (_super) {
    __extends(Popper, _super);
    function Popper() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.openPopper = function (popperNode) {
            if (!popperNode) {
                return;
            }
            if (_this.props.anchorElement) {
                _this.popper = new PopperJS(_this.props.anchorElement, popperNode, __assign({ placement: _this.props.placement }, _this.props.popperOptions));
            }
            else {
                console.warn("Popper: anchorElement was not defined. A valid anchorElement must be provided to render a Popper");
            }
        };
        return _this;
    }
    Popper.prototype.componentWillUnmount = function () {
        if (this.popper) {
            this.popper.destroy();
            this.popper = null;
        }
    };
    Popper.prototype.render = function () {
        if (!this.props.open) {
            return null;
        }
        if (!this.props.portal) {
            return this.renderPopper();
        }
        return ReactDOM.createPortal(this.renderPopper(), this.props.containerElement || document.body);
    };
    Popper.prototype.renderPopper = function () {
        var _a = this.props, anchorElement = _a.anchorElement, children = _a.children, containerElement = _a.containerElement, open = _a.open, placement = _a.placement, popperOptions = _a.popperOptions, portal = _a.portal, elemProps = __rest(_a, ["anchorElement", "children", "containerElement", "open", "placement", "popperOptions", "portal"]);
        return (React.createElement("div", __assign({}, elemProps, { ref: this.openPopper }), this.props.children));
    };
    Popper.defaultProps = {
        open: true,
        placement: 'bottom',
        portal: true,
    };
    return Popper;
}(React.PureComponent));
export { Popper };
