import { keyframes } from '@emotion/core';
import canvas from '@workday/canvas-kit-react-core';
import memoize from 'lodash/memoize';
function calculateFocusRing(_a) {
    var ringWidth = _a.ringWidth, separationWidth = _a.separationWidth, animate = _a.animate, inset = _a.inset, innerShadowColor = _a.innerShadowColor, outerShadowColor = _a.outerShadowColor;
    var endingInnerShadow = (inset ? 'inset ' : '') + '0 0 0 ' + separationWidth + 'px ' + innerShadowColor;
    var endingOuterShadow = (inset ? 'inset ' : '') + '0 0 0 ' + (ringWidth + separationWidth) + 'px ' + outerShadowColor;
    var endingBoxShadow = inset
        ? "" + endingOuterShadow
        : endingInnerShadow + ", " + endingOuterShadow;
    if (animate) {
        var fadeIn = keyframes({
            '0%': { boxShadow: endingBoxShadow },
            '100%': { boxShadow: endingBoxShadow },
        });
        return { animation: fadeIn + " 100ms", boxShadow: endingBoxShadow };
    }
    return { boxShadow: endingBoxShadow };
}
export var memoizedFocusRing = memoize(calculateFocusRing, function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    return JSON.stringify(args);
});
export default function focusRing(ringWidth, separationWidth, animate, inset, innerShadowColor, outerShadowColor, memoizeCalculation) {
    if (ringWidth === void 0) { ringWidth = 2; }
    if (separationWidth === void 0) { separationWidth = 0; }
    if (animate === void 0) { animate = true; }
    if (inset === void 0) { inset = false; }
    if (innerShadowColor === void 0) { innerShadowColor = canvas.colors.frenchVanilla100; }
    if (outerShadowColor === void 0) { outerShadowColor = canvas.commonColors.focusOutline; }
    if (memoizeCalculation === void 0) { memoizeCalculation = true; }
    var argsToPass = {
        ringWidth: ringWidth,
        separationWidth: separationWidth,
        animate: animate,
        inset: inset,
        innerShadowColor: innerShadowColor,
        outerShadowColor: outerShadowColor,
    };
    if (memoizeCalculation) {
        return memoizedFocusRing(argsToPass);
    }
    return calculateFocusRing(argsToPass);
}
