"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
var design_assets_types_1 = require("@workday/design-assets-types");
var Icon_1 = __importDefault(require("./Icon"));
exports.appletIconStyles = function (_a) {
    var _b = _a.color, color = _b === void 0 ? canvas_kit_react_core_1.BrandingColor.Blueberry : _b;
    if (!Object.values(canvas_kit_react_core_1.BrandingColor).includes(color)) {
        throw Error("Color \"" + color + "\" not found");
    }
    var colorNames = {
        100: color + "100",
        200: color + "200",
        300: color + "300",
        400: color + "400",
        500: color + "500",
    };
    return {
        '& .color-100': {
            fill: canvas_kit_react_core_1.colors.frenchVanilla100,
        },
        '& .color-200': {
            fill: canvas_kit_react_core_1.colors[colorNames[200]],
        },
        '& .color-300': {
            fill: canvas_kit_react_core_1.colors[colorNames[300]],
        },
        '& .color-400': {
            fill: canvas_kit_react_core_1.colors[colorNames[400]],
        },
        '& .color-400-alpha-20': {
            fill: canvas_kit_react_core_1.colors[colorNames[400]],
        },
        '& .color-500': {
            fill: canvas_kit_react_core_1.colors[colorNames[500]],
        },
    };
};
var AppletIcon = (function (_super) {
    __extends(AppletIcon, _super);
    function AppletIcon() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AppletIcon.prototype.render = function () {
        var _a = this.props, icon = _a.icon, color = _a.color, size = _a.size, elemProps = __rest(_a, ["icon", "color", "size"]);
        return (React.createElement(Icon_1.default, { src: icon, type: design_assets_types_1.CanvasIconTypes.Applet, styles: exports.appletIconStyles({ color: color }), size: size, elemProps: elemProps }));
    };
    AppletIcon.Colors = canvas_kit_react_core_1.BrandingColor;
    return AppletIcon;
}(React.Component));
exports.default = AppletIcon;
