var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import { colors, BrandingColor } from '@workday/canvas-kit-react-core';
import { CanvasIconTypes } from '@workday/design-assets-types';
import Icon from './Icon';
export var appletIconStyles = function (_a) {
    var _b = _a.color, color = _b === void 0 ? BrandingColor.Blueberry : _b;
    if (!Object.values(BrandingColor).includes(color)) {
        throw Error("Color \"" + color + "\" not found");
    }
    var colorNames = {
        100: color + "100",
        200: color + "200",
        300: color + "300",
        400: color + "400",
        500: color + "500",
    };
    return {
        '& .color-100': {
            fill: colors.frenchVanilla100,
        },
        '& .color-200': {
            fill: colors[colorNames[200]],
        },
        '& .color-300': {
            fill: colors[colorNames[300]],
        },
        '& .color-400': {
            fill: colors[colorNames[400]],
        },
        '& .color-400-alpha-20': {
            fill: colors[colorNames[400]],
        },
        '& .color-500': {
            fill: colors[colorNames[500]],
        },
    };
};
var AppletIcon = (function (_super) {
    __extends(AppletIcon, _super);
    function AppletIcon() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AppletIcon.prototype.render = function () {
        var _a = this.props, icon = _a.icon, color = _a.color, size = _a.size, elemProps = __rest(_a, ["icon", "color", "size"]);
        return (React.createElement(Icon, { src: icon, type: CanvasIconTypes.Applet, styles: appletIconStyles({ color: color }), size: size, elemProps: elemProps }));
    };
    AppletIcon.Colors = BrandingColor;
    return AppletIcon;
}(React.Component));
export default AppletIcon;
