var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import styled from '@emotion/styled';
import isPropValid from '@emotion/is-prop-valid';
import { colors, borderRadius } from '@workday/canvas-kit-react-core';
import SystemIcon from './SystemIcon';
import { pickForegroundColor } from '@workday/canvas-kit-react-common';
export var SystemIconCircleSize;
(function (SystemIconCircleSize) {
    SystemIconCircleSize[SystemIconCircleSize["xs"] = 16] = "xs";
    SystemIconCircleSize[SystemIconCircleSize["s"] = 24] = "s";
    SystemIconCircleSize[SystemIconCircleSize["m"] = 32] = "m";
    SystemIconCircleSize[SystemIconCircleSize["l"] = 40] = "l";
    SystemIconCircleSize[SystemIconCircleSize["xl"] = 64] = "xl";
    SystemIconCircleSize[SystemIconCircleSize["xxl"] = 120] = "xxl";
})(SystemIconCircleSize || (SystemIconCircleSize = {}));
var Container = styled('div', {
    shouldForwardProp: function (prop) { return isPropValid(prop) && prop !== 'size'; },
})({
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    padding: 0,
    border: 0,
    borderRadius: borderRadius.circle,
    boxSizing: 'border-box',
    overflow: 'hidden',
    '& img': {
        width: '100%',
        height: '100%',
    },
}, function (_a) {
    var background = _a.background;
    return ({
        background: background,
    });
}, function (_a) {
    var size = _a.size;
    return ({
        width: size,
        height: size,
    });
});
var SystemIconCircle = (function (_super) {
    __extends(SystemIconCircle, _super);
    function SystemIconCircle() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SystemIconCircle.prototype.render = function () {
        var _a = this.props, background = _a.background, size = _a.size, icon = _a.icon, elemProps = __rest(_a, ["background", "size", "icon"]);
        var iconColor = pickForegroundColor(background, 'rgba(0,0,0,0.65)');
        var iconSize = size * 0.625;
        return (React.createElement(Container, __assign({ background: background, size: size }, elemProps),
            React.createElement(SystemIcon, { icon: icon, color: iconColor, colorHover: iconColor, size: iconSize })));
    };
    SystemIconCircle.Size = SystemIconCircleSize;
    SystemIconCircle.defaultProps = {
        background: colors.soap300,
        size: SystemIconCircleSize.l,
    };
    return SystemIconCircle;
}(React.Component));
export default SystemIconCircle;
