"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var styled_1 = __importDefault(require("@emotion/styled"));
var core_1 = require("@emotion/core");
var v4_1 = __importDefault(require("uuid/v4"));
var canvas_kit_react_card_1 = __importDefault(require("@workday/canvas-kit-react-card"));
var canvas_kit_react_button_1 = require("@workday/canvas-kit-react-button");
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
var canvas_kit_react_common_1 = require("@workday/canvas-kit-react-common");
var canvas_system_icons_web_1 = require("@workday/canvas-system-icons-web");
var PopupPadding;
(function (PopupPadding) {
    PopupPadding["zero"] = "0px";
    PopupPadding["s"] = "16px";
    PopupPadding["l"] = "32px";
})(PopupPadding = exports.PopupPadding || (exports.PopupPadding = {}));
var closeIconSpacing = canvas_kit_react_core_1.spacing.xs;
var closeIconSpacingSmall = 10;
var popupAnimation = function (transformOrigin) {
    var translate = canvas_kit_react_common_1.getTranslateFromOrigin(transformOrigin, canvas_kit_react_core_1.spacing.xxs);
    return core_1.keyframes(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    0% {\n      opacity: 0;\n      transform: translate(", "px, ", "px);\n    }\n    100% {\n      opacity: 1;\n      transform: translate(0);\n    }\n  "], ["\n    0% {\n      opacity: 0;\n      transform: translate(", "px, ", "px);\n    }\n    100% {\n      opacity: 1;\n      transform: translate(0);\n    }\n  "])), translate.x, translate.y);
};
var Container = styled_1.default('div')({
    position: 'relative',
}, function (_a) {
    var width = _a.width;
    return width && { width: width };
}, function (_a) {
    var transformOrigin = _a.transformOrigin;
    return ({
        animation: popupAnimation(transformOrigin),
        animationDuration: '150ms',
        animationTimingFunction: 'ease-out',
        transformOrigin: transformOrigin.vertical + " " + transformOrigin.horizontal,
    });
});
var CloseIconContainer = styled_1.default('div')({
    position: 'absolute',
}, function (_a) {
    var closeIconSize = _a.closeIconSize;
    return ({
        right: closeIconSize === canvas_kit_react_button_1.IconButton.Size.Small ? closeIconSpacingSmall : closeIconSpacing,
        top: closeIconSize === canvas_kit_react_button_1.IconButton.Size.Small ? closeIconSpacingSmall : closeIconSpacing,
    });
});
var Popup = (function (_super) {
    __extends(Popup, _super);
    function Popup() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = v4_1.default();
        _this.closeButtonRef = React.createRef();
        return _this;
    }
    Popup.prototype.render = function () {
        var _a = this.props, handleClose = _a.handleClose, padding = _a.padding, width = _a.width, heading = _a.heading, depth = _a.depth, closeIconSize = _a.closeIconSize, transformOrigin = _a.transformOrigin, popupRef = _a.popupRef, closeLabel = _a.closeLabel, elemProps = __rest(_a, ["handleClose", "padding", "width", "heading", "depth", "closeIconSize", "transformOrigin", "popupRef", "closeLabel"]);
        return (React.createElement(Container, __assign({ transformOrigin: transformOrigin, width: width, role: "dialog", "aria-labelledby": heading ? this.id : undefined, ref: popupRef }, elemProps),
            handleClose && (React.createElement(CloseIconContainer, { closeIconSize: closeIconSize },
                React.createElement(canvas_kit_react_button_1.IconButton, { "data-close": "close", ref: this.closeButtonRef, variant: canvas_kit_react_button_1.IconButton.Variant.Plain, size: closeIconSize, onClick: handleClose, icon: canvas_system_icons_web_1.xIcon, title: closeLabel, "aria-label": closeLabel }))),
            React.createElement(canvas_kit_react_card_1.default, { depth: depth, heading: heading, headingId: heading ? this.id : undefined, width: width, padding: padding }, this.props.children)));
    };
    Popup.Padding = PopupPadding;
    Popup.defaultProps = {
        padding: Popup.Padding.l,
        closeIconSize: canvas_kit_react_button_1.IconButton.Size.Medium,
        closeLabel: 'Close',
        transformOrigin: {
            horizontal: 'center',
            vertical: 'top',
        },
    };
    return Popup;
}(React.Component));
exports.default = Popup;
var templateObject_1;
