import * as React from 'react';
import { IconButtonSize } from '@workday/canvas-kit-react-button';
import { CanvasDepthValue } from '@workday/canvas-kit-react-core';
import { TransformOrigin } from '@workday/canvas-kit-react-common';
export declare enum PopupPadding {
    zero = "0px",
    s = "16px",
    l = "32px"
}
export interface PopupProps extends React.HTMLAttributes<HTMLDivElement> {
    padding: PopupPadding;
    transformOrigin: TransformOrigin;
    closeIconSize: IconButtonSize;
    popupRef?: React.Ref<HTMLDivElement>;
    handleClose?: () => void;
    width?: number | string;
    heading?: React.ReactNode;
    depth?: CanvasDepthValue;
    closeLabel: string;
}
export default class Popup extends React.Component<PopupProps> {
    static Padding: typeof PopupPadding;
    static defaultProps: {
        padding: PopupPadding;
        closeIconSize: IconButtonSize;
        closeLabel: string;
        transformOrigin: {
            horizontal: string;
            vertical: string;
        };
    };
    private id;
    private closeButtonRef;
    render(): JSX.Element;
}
