"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var styled_1 = __importDefault(require("@emotion/styled"));
var canvas_kit_react_common_1 = require("@workday/canvas-kit-react-common");
var canvas_kit_react_core_1 = __importStar(require("@workday/canvas-kit-react-core"));
var v4_1 = __importDefault(require("uuid/v4"));
var radioBorderRadius = 9;
var radioDot = 8;
var radioHeight = 18;
var radioTapArea = canvas_kit_react_core_1.spacingNumbers.m;
var radioContainerHeight = radioTapArea;
var radioLabelDistance = canvas_kit_react_core_1.spacingNumbers.xs;
var radioWidth = 18;
var rippleRadius = (canvas_kit_react_core_1.spacingNumbers.l - radioWidth) / 2;
var RadioContainer = styled_1.default('div')({
    display: 'flex',
    alignItems: 'center',
    minHeight: radioContainerHeight,
    position: 'relative',
});
var RadioInputWrapper = styled_1.default('div')({
    height: radioHeight,
    width: radioWidth,
    marginTop: '3px',
    alignSelf: 'flex-start',
    '&::after': {
        borderRadius: canvas_kit_react_core_1.borderRadius.circle,
        boxShadow: '0 0 0 0 ' + canvas_kit_react_core_1.colors.soap200,
        content: '""',
        display: 'inline-block',
        height: radioHeight,
        transition: 'box-shadow 150ms ease-out',
        width: radioWidth,
        zIndex: 1,
    },
}, function (_a) {
    var disabled = _a.disabled;
    return ({
        '&:hover::after': {
            boxShadow: disabled ? undefined : '0 0 0 ' + rippleRadius + 'px ' + canvas_kit_react_core_1.colors.soap200,
        },
    });
});
var RadioInput = styled_1.default('input')({
    borderRadius: radioBorderRadius,
    width: radioTapArea,
    height: radioTapArea,
    margin: 0,
    marginTop: '-3px',
    marginLeft: '-3px',
    position: 'absolute',
    opacity: 0,
    '&:focus, &:active': {
        outline: 'none',
    },
    '&:focus, &:active, &focus:hover, &:active:hover': {
        '& ~ div:first-of-type': {
            borderColor: canvas_kit_react_core_1.colors.blueberry400,
            borderWidth: '2px',
            zIndex: 2,
        },
    },
    '&:checked:focus ~ div:first-of-type': __assign({}, canvas_kit_react_common_1.focusRing(2, 2)),
}, function (_a) {
    var _b;
    var checked = _a.checked, disabled = _a.disabled;
    return (_b = {
            cursor: disabled ? undefined : 'pointer',
            '&:focus:hover ~ div:first-of-type': {
                borderColor: disabled ? canvas_kit_react_core_1.inputColors.border : canvas_kit_react_core_1.colors.blueberry400,
            }
        },
        _b["[data-whatinput=\"mouse\"] &:focus ~ div:first-of-type,\n      [data-whatinput=\"touch\"] &:focus ~ div:first-of-type,\n      [data-whatinput=\"pointer\"] &:focus ~ div:first-of-type"] = __assign({}, canvas_kit_react_common_1.focusRing(0, 0), { borderWidth: '1px', borderColor: checked ? canvas_kit_react_core_1.colors.blueberry400 : canvas_kit_react_core_1.inputColors.border, '&:hover': {
                borderColor: checked ? canvas_kit_react_core_1.colors.blueberry400 : canvas_kit_react_core_1.inputColors.hoverBorder,
            } }),
        _b["[data-whatinput=\"mouse\"] &:hover ~ div:first-of-type"] = {
            backgroundColor: checked
                ? canvas_kit_react_core_1.colors.blueberry400
                : disabled
                    ? canvas_kit_react_core_1.inputColors.disabled.background
                    : 'white',
            borderColor: checked
                ? canvas_kit_react_core_1.colors.blueberry400
                : disabled
                    ? canvas_kit_react_core_1.inputColors.disabled.border
                    : canvas_kit_react_core_1.inputColors.hoverBorder,
            borderWidth: '1px',
        },
        _b);
});
var RadioBackground = styled_1.default('div')({
    alignItems: 'center',
    backgroundColor: canvas_kit_react_core_1.colors.frenchVanilla100,
    borderRadius: radioBorderRadius,
    borderStyle: 'solid',
    borderWidth: '1px',
    boxSizing: 'border-box',
    display: 'flex',
    height: radioHeight,
    justifyContent: 'center',
    padding: '0px 2px',
    pointerEvents: 'none',
    position: 'absolute',
    transition: 'border 200ms ease, background 200ms',
    width: radioWidth,
}, function (_a) {
    var checked = _a.checked, disabled = _a.disabled;
    return ({
        borderColor: checked
            ? canvas_kit_react_core_1.colors.blueberry400
            : disabled
                ? canvas_kit_react_core_1.inputColors.disabled.border
                : canvas_kit_react_core_1.inputColors.border,
        backgroundColor: checked
            ? canvas_kit_react_core_1.colors.blueberry400
            : disabled
                ? canvas_kit_react_core_1.inputColors.disabled.background
                : 'white',
    });
});
var RadioCheck = styled_1.default('div')({
    backgroundColor: canvas_kit_react_core_1.colors.frenchVanilla100,
    borderRadius: radioBorderRadius,
    display: 'flex',
    flexDirection: 'column',
    height: radioDot,
    pointerEvents: 'none',
    transition: 'transform 200ms ease, opacity 200ms ease',
    width: radioDot,
}, function (_a) {
    var checked = _a.checked;
    return ({
        opacity: checked ? 1 : 0,
        transform: checked ? 'scale(1)' : 'scale(0.5)',
    });
});
var RadioLabel = styled_1.default('label')(__assign({}, canvas_kit_react_core_1.default.type.body, { paddingLeft: radioLabelDistance }), function (_a) {
    var disabled = _a.disabled;
    return (disabled ? { color: canvas_kit_react_core_1.inputColors.disabled.text } : { cursor: 'pointer' });
});
var Radio = (function (_super) {
    __extends(Radio, _super);
    function Radio() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = v4_1.default();
        return _this;
    }
    Radio.prototype.render = function () {
        var _a = this.props, checked = _a.checked, disabled = _a.disabled, _b = _a.id, id = _b === void 0 ? this.id : _b, inputRef = _a.inputRef, label = _a.label, name = _a.name, onChange = _a.onChange, value = _a.value, elemProps = __rest(_a, ["checked", "disabled", "id", "inputRef", "label", "name", "onChange", "value"]);
        return (React.createElement(RadioContainer, null,
            React.createElement(RadioInputWrapper, { disabled: disabled },
                React.createElement(RadioInput, __assign({ checked: checked, disabled: disabled, id: id, ref: inputRef, name: name, onChange: onChange, type: "radio", value: value, "aria-checked": checked }, elemProps)),
                React.createElement(RadioBackground, { checked: checked, disabled: disabled },
                    React.createElement(RadioCheck, { checked: checked }))),
            label && (React.createElement(RadioLabel, { htmlFor: id, disabled: disabled }, label))));
    };
    Radio.defaultProps = {
        checked: false,
        label: '',
    };
    return Radio;
}(React.Component));
exports.default = Radio;
