"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var styled_1 = __importDefault(require("@emotion/styled"));
var Radio_1 = __importDefault(require("./Radio"));
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
var canvas_kit_react_common_1 = require("@workday/canvas-kit-react-common");
var Container = styled_1.default('div')({
    display: 'inline-block',
    boxSizing: 'border-box',
    '& > div': {
        margin: canvas_kit_react_core_1.spacing.xxs + " " + canvas_kit_react_core_1.spacing.zero,
        '&:first-child': {
            marginTop: canvas_kit_react_core_1.spacing.xxxs,
        },
        '&:last-child': {
            marginBottom: canvas_kit_react_core_1.spacing.xxxs,
        },
    },
}, function (_a) {
    var grow = _a.grow;
    return grow && { width: '100%' };
}, function (_a) {
    var error = _a.error;
    var errorBorderColor;
    var errorRingColor;
    if (error === canvas_kit_react_common_1.ErrorType.Error) {
        errorRingColor = canvas_kit_react_core_1.inputColors.error.border;
    }
    else if (error === canvas_kit_react_common_1.ErrorType.Alert) {
        errorRingColor = canvas_kit_react_core_1.inputColors.warning.border;
        errorBorderColor = canvas_kit_react_core_1.colors.cantaloupe600;
    }
    else {
        return {};
    }
    return {
        borderRadius: canvas_kit_react_core_1.borderRadius.m,
        transition: '100ms box-shadow',
        boxShadow: errorBorderColor
            ? "inset 0 0 0 1px " + errorBorderColor + ", inset 0 0 0 3px " + errorRingColor
            : "inset 0 0 0 2px " + errorRingColor,
        padding: canvas_kit_react_core_1.spacing.xxxs + " " + canvas_kit_react_core_1.spacing.xs,
        margin: "-" + canvas_kit_react_core_1.spacing.xxxs + " -" + canvas_kit_react_core_1.spacing.xs,
    };
});
var RadioGroup = (function (_super) {
    __extends(RadioGroup, _super);
    function RadioGroup() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.renderChild = function (child, index) {
            if (typeof child.type === typeof Radio_1.default) {
                var childProps = child.props;
                var checked = typeof _this.props.value === 'number'
                    ? index === _this.props.value
                    : childProps.value === _this.props.value;
                var name_1 = _this.props.name ? _this.props.name : childProps.name;
                return React.cloneElement(child, {
                    checked: checked,
                    name: name_1,
                    onChange: _this.onRadioChange.bind(_this, childProps.onChange, index),
                });
            }
            return child;
        };
        _this.onRadioChange = function (existingOnChange, index, event) {
            if (existingOnChange) {
                existingOnChange(event);
            }
            var target = event.currentTarget;
            if (target && _this.props.onChange) {
                if (target.value) {
                    _this.props.onChange(target.value);
                }
                else {
                    _this.props.onChange(index);
                }
            }
        };
        return _this;
    }
    RadioGroup.prototype.render = function () {
        var _a = this.props, children = _a.children, error = _a.error, onChange = _a.onChange, value = _a.value, grow = _a.grow, elemProps = __rest(_a, ["children", "error", "onChange", "value", "grow"]);
        return (React.createElement(Container, __assign({ error: error, grow: grow }, elemProps), React.Children.map(children, this.renderChild)));
    };
    RadioGroup.ErrorType = canvas_kit_react_common_1.ErrorType;
    RadioGroup.defaultProps = {
        value: 0,
    };
    return RadioGroup;
}(React.Component));
exports.default = RadioGroup;
