"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var React = __importStar(require("react"));
var styled_1 = __importDefault(require("@emotion/styled"));
var v4_1 = __importDefault(require("uuid/v4"));
var canvas_kit_react_common_1 = require("@workday/canvas-kit-react-common");
var canvas_kit_react_core_1 = require("@workday/canvas-kit-react-core");
var circleSize = canvas_kit_react_core_1.spacing.xs;
var switchWidth = canvas_kit_react_core_1.spacing.l;
var switchHeight = canvas_kit_react_core_1.spacing.s;
var switchTapArea = canvas_kit_react_core_1.spacing.l;
var translateLength = canvas_kit_react_core_1.spacing.s;
var SwitchContainer = styled_1.default('div')({
    position: 'relative',
    height: canvas_kit_react_core_1.spacing.m,
    width: switchTapArea,
});
var SwitchInput = styled_1.default('input')(__assign({ position: 'absolute', height: canvas_kit_react_core_1.spacing.m, width: switchTapArea, margin: 0, marginLeft: canvas_kit_react_core_1.spacing.xxxs, borderRadius: canvas_kit_react_core_1.borderRadius.circle, opacity: 0, '&:focus, &:active': {
        outline: 'none',
        '& ~ div:first-of-type': __assign({}, canvas_kit_react_common_1.focusRing(2, 2, false)),
    } }, canvas_kit_react_common_1.mouseFocusBehavior({
    '&:focus, &:active': {
        '& ~ div:first-of-type': __assign({}, canvas_kit_react_common_1.focusRing(0, 0), { animation: 'none' }),
    },
})), function (_a) {
    var disabled = _a.disabled;
    return ({
        cursor: disabled ? 'not-allowed' : 'pointer',
    });
}, function (_a) {
    var error = _a.error;
    var errorRingColor;
    var errorRingBorderColor = 'transparent';
    if (error === canvas_kit_react_common_1.ErrorType.Error) {
        errorRingColor = canvas_kit_react_core_1.inputColors.error.border;
    }
    else if (error === canvas_kit_react_common_1.ErrorType.Alert) {
        errorRingColor = canvas_kit_react_core_1.inputColors.warning.border;
        errorRingBorderColor = canvas_kit_react_core_1.colors.cantaloupe600;
    }
    else {
        return;
    }
    var styles = {
        '& ~ div:first-of-type': {
            boxShadow: "\n          0 0 0 2px " + canvas_kit_react_core_1.colors.frenchVanilla100 + ",\n          0 0 0 4px " + errorRingColor + ",\n          0 0 0 5px " + errorRingBorderColor,
        },
        '&:focus ~ div:first-of-type': __assign({}, canvas_kit_react_common_1.focusRing(2, 2, false)),
    };
    return __assign({}, styles, canvas_kit_react_common_1.mouseFocusBehavior(__assign({}, styles, { '&:focus ~ div:first-of-type, &:active ~ div:first-of-type': {
            boxShadow: "\n            0 0 0 2px " + canvas_kit_react_core_1.colors.frenchVanilla100 + ",\n            0 0 0 4px " + errorRingColor + ",\n            0 0 0 5px " + errorRingBorderColor,
        } })));
});
var SwitchBackground = styled_1.default('div')({
    boxSizing: 'border-box',
    position: 'absolute',
    display: 'flex',
    alignItems: 'center',
    pointerEvents: 'none',
    marginTop: canvas_kit_react_core_1.spacing.xxxs,
    width: switchWidth,
    height: switchHeight,
    borderRadius: canvas_kit_react_core_1.borderRadius.circle,
    padding: '0px 2px',
    transition: 'background-color 200ms ease',
}, function (_a) {
    var checked = _a.checked, disabled = _a.disabled;
    return ({
        backgroundColor: disabled ? canvas_kit_react_core_1.colors.soap400 : checked ? canvas_kit_react_core_1.colors.blueberry500 : canvas_kit_react_core_1.colors.licorice200,
    });
});
var SwitchCircle = styled_1.default('div')(function (_a) {
    var checked = _a.checked;
    return (__assign({ width: circleSize, height: circleSize, borderRadius: canvas_kit_react_core_1.borderRadius.circle }, canvas_kit_react_core_1.depth[1], { backgroundColor: canvas_kit_react_core_1.colors.frenchVanilla100, transform: checked ? "translateX(" + translateLength + ")" : 'translateX(0)', transition: 'transform 150ms ease', pointerEvents: 'none' }));
});
var Switch = (function (_super) {
    __extends(Switch, _super);
    function Switch() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = v4_1.default();
        return _this;
    }
    Switch.prototype.render = function () {
        var _a = this.props, checked = _a.checked, disabled = _a.disabled, _b = _a.id, id = _b === void 0 ? this.id : _b, inputRef = _a.inputRef, onChange = _a.onChange, value = _a.value, elemProps = __rest(_a, ["checked", "disabled", "id", "inputRef", "onChange", "value"]);
        return (React.createElement(SwitchContainer, null,
            React.createElement(SwitchInput, __assign({ checked: checked, disabled: disabled, id: id, ref: inputRef, onChange: onChange, role: "checkbox", tabIndex: 0, type: "checkbox", value: value }, elemProps)),
            React.createElement(SwitchBackground, { checked: checked, disabled: disabled },
                React.createElement(SwitchCircle, { checked: checked }))));
    };
    Switch.defaultProps = {
        checked: false,
    };
    return Switch;
}(React.Component));
exports.default = Switch;
