var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import * as React from 'react';
import styled from '@emotion/styled';
import uuid from 'uuid/v4';
import { ErrorType, focusRing, mouseFocusBehavior } from '@workday/canvas-kit-react-common';
import { borderRadius, colors, inputColors, depth, spacing } from '@workday/canvas-kit-react-core';
var circleSize = spacing.xs;
var switchWidth = spacing.l;
var switchHeight = spacing.s;
var switchTapArea = spacing.l;
var translateLength = spacing.s;
var SwitchContainer = styled('div')({
    position: 'relative',
    height: spacing.m,
    width: switchTapArea,
});
var SwitchInput = styled('input')(__assign({ position: 'absolute', height: spacing.m, width: switchTapArea, margin: 0, marginLeft: spacing.xxxs, borderRadius: borderRadius.circle, opacity: 0, '&:focus, &:active': {
        outline: 'none',
        '& ~ div:first-of-type': __assign({}, focusRing(2, 2, false)),
    } }, mouseFocusBehavior({
    '&:focus, &:active': {
        '& ~ div:first-of-type': __assign({}, focusRing(0, 0), { animation: 'none' }),
    },
})), function (_a) {
    var disabled = _a.disabled;
    return ({
        cursor: disabled ? 'not-allowed' : 'pointer',
    });
}, function (_a) {
    var error = _a.error;
    var errorRingColor;
    var errorRingBorderColor = 'transparent';
    if (error === ErrorType.Error) {
        errorRingColor = inputColors.error.border;
    }
    else if (error === ErrorType.Alert) {
        errorRingColor = inputColors.warning.border;
        errorRingBorderColor = colors.cantaloupe600;
    }
    else {
        return;
    }
    var styles = {
        '& ~ div:first-of-type': {
            boxShadow: "\n          0 0 0 2px " + colors.frenchVanilla100 + ",\n          0 0 0 4px " + errorRingColor + ",\n          0 0 0 5px " + errorRingBorderColor,
        },
        '&:focus ~ div:first-of-type': __assign({}, focusRing(2, 2, false)),
    };
    return __assign({}, styles, mouseFocusBehavior(__assign({}, styles, { '&:focus ~ div:first-of-type, &:active ~ div:first-of-type': {
            boxShadow: "\n            0 0 0 2px " + colors.frenchVanilla100 + ",\n            0 0 0 4px " + errorRingColor + ",\n            0 0 0 5px " + errorRingBorderColor,
        } })));
});
var SwitchBackground = styled('div')({
    boxSizing: 'border-box',
    position: 'absolute',
    display: 'flex',
    alignItems: 'center',
    pointerEvents: 'none',
    marginTop: spacing.xxxs,
    width: switchWidth,
    height: switchHeight,
    borderRadius: borderRadius.circle,
    padding: '0px 2px',
    transition: 'background-color 200ms ease',
}, function (_a) {
    var checked = _a.checked, disabled = _a.disabled;
    return ({
        backgroundColor: disabled ? colors.soap400 : checked ? colors.blueberry500 : colors.licorice200,
    });
});
var SwitchCircle = styled('div')(function (_a) {
    var checked = _a.checked;
    return (__assign({ width: circleSize, height: circleSize, borderRadius: borderRadius.circle }, depth[1], { backgroundColor: colors.frenchVanilla100, transform: checked ? "translateX(" + translateLength + ")" : 'translateX(0)', transition: 'transform 150ms ease', pointerEvents: 'none' }));
});
var Switch = (function (_super) {
    __extends(Switch, _super);
    function Switch() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.id = uuid();
        return _this;
    }
    Switch.prototype.render = function () {
        var _a = this.props, checked = _a.checked, disabled = _a.disabled, _b = _a.id, id = _b === void 0 ? this.id : _b, inputRef = _a.inputRef, onChange = _a.onChange, value = _a.value, elemProps = __rest(_a, ["checked", "disabled", "id", "inputRef", "onChange", "value"]);
        return (React.createElement(SwitchContainer, null,
            React.createElement(SwitchInput, __assign({ checked: checked, disabled: disabled, id: id, ref: inputRef, onChange: onChange, role: "checkbox", tabIndex: 0, type: "checkbox", value: value }, elemProps)),
            React.createElement(SwitchBackground, { checked: checked, disabled: disabled },
                React.createElement(SwitchCircle, { checked: checked }))));
    };
    Switch.defaultProps = {
        checked: false,
    };
    return Switch;
}(React.Component));
export default Switch;
